/*
 * Copyright 2022 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package androidx.compose.material.icons.rounded

import androidx.compose.material.icons.Icons
import androidx.compose.material.icons.materialIcon
import androidx.compose.material.icons.materialPath
import androidx.compose.ui.graphics.vector.ImageVector

public val Icons.Rounded.AttachFile: ImageVector
    get() {
        if (_attachFile != null) {
            return _attachFile!!
        }
        _attachFile = materialIcon(name = "Rounded.AttachFile") {
            materialPath {
                moveTo(16.5f, 6.75f)
                verticalLineToRelative(10.58f)
                curveToRelative(0.0f, 2.09f, -1.53f, 3.95f, -3.61f, 4.15f)
                curveToRelative(-2.39f, 0.23f, -4.39f, -1.64f, -4.39f, -3.98f)
                verticalLineTo(5.14f)
                curveToRelative(0.0f, -1.31f, 0.94f, -2.5f, 2.24f, -2.63f)
                curveToRelative(1.5f, -0.15f, 2.76f, 1.02f, 2.76f, 2.49f)
                verticalLineToRelative(10.5f)
                curveToRelative(0.0f, 0.55f, -0.45f, 1.0f, -1.0f, 1.0f)
                reflectiveCurveToRelative(-1.0f, -0.45f, -1.0f, -1.0f)
                verticalLineTo(6.75f)
                curveToRelative(0.0f, -0.41f, -0.34f, -0.75f, -0.75f, -0.75f)
                reflectiveCurveToRelative(-0.75f, 0.34f, -0.75f, 0.75f)
                verticalLineToRelative(8.61f)
                curveToRelative(0.0f, 1.31f, 0.94f, 2.5f, 2.24f, 2.63f)
                curveToRelative(1.5f, 0.15f, 2.76f, -1.02f, 2.76f, -2.49f)
                verticalLineTo(5.17f)
                curveToRelative(0.0f, -2.09f, -1.53f, -3.95f, -3.61f, -4.15f)
                curveTo(9.01f, 0.79f, 7.0f, 2.66f, 7.0f, 5.0f)
                verticalLineToRelative(12.27f)
                curveToRelative(0.0f, 2.87f, 2.1f, 5.44f, 4.96f, 5.71f)
                curveToRelative(3.29f, 0.3f, 6.04f, -2.26f, 6.04f, -5.48f)
                verticalLineTo(6.75f)
                curveToRelative(0.0f, -0.41f, -0.34f, -0.75f, -0.75f, -0.75f)
                reflectiveCurveToRelative(-0.75f, 0.34f, -0.75f, 0.75f)
                close()
            }
        }
        return _attachFile!!
    }

private var _attachFile: ImageVector? = null
