/*
 * Copyright 2022 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package androidx.compose.material.icons.rounded

import androidx.compose.material.icons.Icons
import androidx.compose.material.icons.materialIcon
import androidx.compose.material.icons.materialPath
import androidx.compose.ui.graphics.vector.ImageVector

public val Icons.Rounded.AppsOutage: ImageVector
    get() {
        if (_appsOutage != null) {
            return _appsOutage!!
        }
        _appsOutage = materialIcon(name = "Rounded.AppsOutage") {
            materialPath {
                moveTo(6.0f, 8.0f)
                curveToRelative(1.1f, 0.0f, 2.0f, -0.9f, 2.0f, -2.0f)
                reflectiveCurveTo(7.1f, 4.0f, 6.0f, 4.0f)
                reflectiveCurveTo(4.0f, 4.9f, 4.0f, 6.0f)
                reflectiveCurveTo(4.9f, 8.0f, 6.0f, 8.0f)
                close()
                moveTo(12.0f, 20.0f)
                curveToRelative(1.1f, 0.0f, 2.0f, -0.9f, 2.0f, -2.0f)
                reflectiveCurveToRelative(-0.9f, -2.0f, -2.0f, -2.0f)
                reflectiveCurveToRelative(-2.0f, 0.9f, -2.0f, 2.0f)
                reflectiveCurveTo(10.9f, 20.0f, 12.0f, 20.0f)
                close()
                moveTo(6.0f, 20.0f)
                curveToRelative(1.1f, 0.0f, 2.0f, -0.9f, 2.0f, -2.0f)
                reflectiveCurveToRelative(-0.9f, -2.0f, -2.0f, -2.0f)
                reflectiveCurveToRelative(-2.0f, 0.9f, -2.0f, 2.0f)
                reflectiveCurveTo(4.9f, 20.0f, 6.0f, 20.0f)
                close()
                moveTo(6.0f, 14.0f)
                curveToRelative(1.1f, 0.0f, 2.0f, -0.9f, 2.0f, -2.0f)
                reflectiveCurveToRelative(-0.9f, -2.0f, -2.0f, -2.0f)
                reflectiveCurveToRelative(-2.0f, 0.9f, -2.0f, 2.0f)
                reflectiveCurveTo(4.9f, 14.0f, 6.0f, 14.0f)
                close()
                moveTo(12.0f, 14.0f)
                curveToRelative(1.1f, 0.0f, 2.0f, -0.9f, 2.0f, -2.0f)
                reflectiveCurveToRelative(-0.9f, -2.0f, -2.0f, -2.0f)
                reflectiveCurveToRelative(-2.0f, 0.9f, -2.0f, 2.0f)
                reflectiveCurveTo(10.9f, 14.0f, 12.0f, 14.0f)
                close()
                moveTo(12.07f, 4.0f)
                curveTo(12.05f, 4.0f, 12.02f, 4.0f, 12.0f, 4.0f)
                curveToRelative(-1.1f, 0.0f, -2.0f, 0.9f, -2.0f, 2.0f)
                reflectiveCurveToRelative(0.9f, 2.0f, 2.0f, 2.0f)
                curveToRelative(0.22f, 0.0f, 0.43f, -0.04f, 0.63f, -0.1f)
                curveTo(12.22f, 7.01f, 12.0f, 6.03f, 12.0f, 5.0f)
                curveTo(12.0f, 4.66f, 12.02f, 4.33f, 12.07f, 4.0f)
                close()
                moveTo(19.0f, 12.0f)
                curveToRelative(-1.03f, 0.0f, -2.01f, -0.22f, -2.9f, -0.63f)
                curveTo(16.04f, 11.57f, 16.0f, 11.78f, 16.0f, 12.0f)
                curveToRelative(0.0f, 1.1f, 0.9f, 2.0f, 2.0f, 2.0f)
                reflectiveCurveToRelative(2.0f, -0.9f, 2.0f, -2.0f)
                curveToRelative(0.0f, -0.02f, 0.0f, -0.05f, 0.0f, -0.07f)
                curveTo(19.67f, 11.98f, 19.34f, 12.0f, 19.0f, 12.0f)
                close()
                moveTo(18.0f, 20.0f)
                curveToRelative(1.1f, 0.0f, 2.0f, -0.9f, 2.0f, -2.0f)
                reflectiveCurveToRelative(-0.9f, -2.0f, -2.0f, -2.0f)
                reflectiveCurveToRelative(-2.0f, 0.9f, -2.0f, 2.0f)
                reflectiveCurveTo(16.9f, 20.0f, 18.0f, 20.0f)
                close()
                moveTo(19.0f, 0.0f)
                curveToRelative(-2.76f, 0.0f, -5.0f, 2.24f, -5.0f, 5.0f)
                reflectiveCurveToRelative(2.24f, 5.0f, 5.0f, 5.0f)
                reflectiveCurveToRelative(5.0f, -2.24f, 5.0f, -5.0f)
                reflectiveCurveTo(21.76f, 0.0f, 19.0f, 0.0f)
                close()
                moveTo(19.5f, 7.5f)
                curveTo(19.5f, 7.78f, 19.28f, 8.0f, 19.0f, 8.0f)
                curveToRelative(-0.27f, 0.0f, -0.5f, -0.22f, -0.5f, -0.5f)
                reflectiveCurveTo(18.72f, 7.0f, 19.0f, 7.0f)
                reflectiveCurveTo(19.5f, 7.22f, 19.5f, 7.5f)
                close()
                moveTo(19.0f, 6.0f)
                curveToRelative(-0.28f, 0.0f, -0.5f, -0.22f, -0.5f, -0.5f)
                verticalLineToRelative(-3.0f)
                curveTo(18.5f, 2.22f, 18.72f, 2.0f, 19.0f, 2.0f)
                reflectiveCurveToRelative(0.5f, 0.22f, 0.5f, 0.5f)
                verticalLineToRelative(3.0f)
                curveTo(19.5f, 5.78f, 19.28f, 6.0f, 19.0f, 6.0f)
                close()
            }
        }
        return _appsOutage!!
    }

private var _appsOutage: ImageVector? = null
