/*
 * Copyright 2022 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package androidx.compose.material.icons.rounded

import androidx.compose.material.icons.Icons
import androidx.compose.material.icons.materialIcon
import androidx.compose.material.icons.materialPath
import androidx.compose.ui.graphics.vector.ImageVector

public val Icons.Rounded.AlignVerticalTop: ImageVector
    get() {
        if (_alignVerticalTop != null) {
            return _alignVerticalTop!!
        }
        _alignVerticalTop = materialIcon(name = "Rounded.AlignVerticalTop") {
            materialPath {
                moveTo(22.0f, 3.0f)
                lineTo(22.0f, 3.0f)
                curveToRelative(0.0f, 0.55f, -0.45f, 1.0f, -1.0f, 1.0f)
                horizontalLineTo(3.0f)
                curveTo(2.45f, 4.0f, 2.0f, 3.55f, 2.0f, 3.0f)
                verticalLineToRelative(0.0f)
                curveToRelative(0.0f, -0.55f, 0.45f, -1.0f, 1.0f, -1.0f)
                horizontalLineToRelative(18.0f)
                curveTo(21.55f, 2.0f, 22.0f, 2.45f, 22.0f, 3.0f)
                close()
                moveTo(8.5f, 22.0f)
                lineTo(8.5f, 22.0f)
                curveToRelative(0.83f, 0.0f, 1.5f, -0.67f, 1.5f, -1.5f)
                verticalLineToRelative(-13.0f)
                curveTo(10.0f, 6.67f, 9.33f, 6.0f, 8.5f, 6.0f)
                horizontalLineToRelative(0.0f)
                curveTo(7.67f, 6.0f, 7.0f, 6.67f, 7.0f, 7.5f)
                verticalLineToRelative(13.0f)
                curveTo(7.0f, 21.33f, 7.67f, 22.0f, 8.5f, 22.0f)
                close()
                moveTo(15.5f, 16.0f)
                lineTo(15.5f, 16.0f)
                curveToRelative(0.83f, 0.0f, 1.5f, -0.67f, 1.5f, -1.5f)
                verticalLineToRelative(-7.0f)
                curveTo(17.0f, 6.67f, 16.33f, 6.0f, 15.5f, 6.0f)
                horizontalLineToRelative(0.0f)
                curveTo(14.67f, 6.0f, 14.0f, 6.67f, 14.0f, 7.5f)
                verticalLineToRelative(7.0f)
                curveTo(14.0f, 15.33f, 14.67f, 16.0f, 15.5f, 16.0f)
                close()
            }
        }
        return _alignVerticalTop!!
    }

private var _alignVerticalTop: ImageVector? = null
