/*
 * Copyright 2022 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package androidx.compose.material.icons.rounded

import androidx.compose.material.icons.Icons
import androidx.compose.material.icons.materialIcon
import androidx.compose.material.icons.materialPath
import androidx.compose.ui.graphics.vector.ImageVector

public val Icons.Rounded.AddTask: ImageVector
    get() {
        if (_addTask != null) {
            return _addTask!!
        }
        _addTask = materialIcon(name = "Rounded.AddTask") {
            materialPath {
                moveTo(21.29f, 5.89f)
                lineToRelative(-10.0f, 10.0f)
                curveToRelative(-0.39f, 0.39f, -1.02f, 0.39f, -1.41f, 0.0f)
                lineToRelative(-2.83f, -2.83f)
                curveToRelative(-0.39f, -0.39f, -0.39f, -1.02f, 0.0f, -1.41f)
                lineToRelative(0.0f, 0.0f)
                curveToRelative(0.39f, -0.39f, 1.02f, -0.39f, 1.41f, 0.0f)
                lineToRelative(2.12f, 2.12f)
                lineToRelative(9.29f, -9.29f)
                curveToRelative(0.39f, -0.39f, 1.02f, -0.39f, 1.41f, 0.0f)
                verticalLineToRelative(0.0f)
                curveTo(21.68f, 4.87f, 21.68f, 5.5f, 21.29f, 5.89f)
                close()
                moveTo(12.0f, 20.0f)
                curveToRelative(-4.71f, 0.0f, -8.48f, -4.09f, -7.95f, -8.9f)
                curveToRelative(0.39f, -3.52f, 3.12f, -6.41f, 6.61f, -6.99f)
                curveToRelative(1.81f, -0.3f, 3.53f, 0.02f, 4.99f, 0.78f)
                curveToRelative(0.39f, 0.2f, 0.86f, 0.13f, 1.17f, -0.18f)
                lineToRelative(0.0f, 0.0f)
                curveToRelative(0.48f, -0.48f, 0.36f, -1.29f, -0.24f, -1.6f)
                curveTo(15.11f, 2.36f, 13.45f, 1.95f, 11.68f, 2.0f)
                curveToRelative(-5.14f, 0.16f, -9.41f, 4.34f, -9.67f, 9.47f)
                curveTo(1.72f, 17.24f, 6.3f, 22.0f, 12.0f, 22.0f)
                curveToRelative(1.2f, 0.0f, 2.34f, -0.21f, 3.41f, -0.6f)
                curveToRelative(0.68f, -0.25f, 0.87f, -1.13f, 0.35f, -1.65f)
                lineToRelative(0.0f, 0.0f)
                curveToRelative(-0.27f, -0.27f, -0.68f, -0.37f, -1.04f, -0.23f)
                curveTo(13.87f, 19.83f, 12.95f, 20.0f, 12.0f, 20.0f)
                close()
                moveTo(19.0f, 15.0f)
                horizontalLineToRelative(-2.0f)
                curveToRelative(-0.55f, 0.0f, -1.0f, 0.45f, -1.0f, 1.0f)
                verticalLineToRelative(0.0f)
                curveToRelative(0.0f, 0.55f, 0.45f, 1.0f, 1.0f, 1.0f)
                horizontalLineToRelative(2.0f)
                verticalLineToRelative(2.0f)
                curveToRelative(0.0f, 0.55f, 0.45f, 1.0f, 1.0f, 1.0f)
                horizontalLineToRelative(0.0f)
                curveToRelative(0.55f, 0.0f, 1.0f, -0.45f, 1.0f, -1.0f)
                verticalLineToRelative(-2.0f)
                horizontalLineToRelative(2.0f)
                curveToRelative(0.55f, 0.0f, 1.0f, -0.45f, 1.0f, -1.0f)
                verticalLineToRelative(0.0f)
                curveToRelative(0.0f, -0.55f, -0.45f, -1.0f, -1.0f, -1.0f)
                horizontalLineToRelative(-2.0f)
                verticalLineToRelative(-2.0f)
                curveToRelative(0.0f, -0.55f, -0.45f, -1.0f, -1.0f, -1.0f)
                horizontalLineToRelative(0.0f)
                curveToRelative(-0.55f, 0.0f, -1.0f, 0.45f, -1.0f, 1.0f)
                verticalLineTo(15.0f)
                close()
            }
        }
        return _addTask!!
    }

private var _addTask: ImageVector? = null
