/*
 * Copyright 2022 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package androidx.compose.material.icons.outlined

import androidx.compose.material.icons.Icons
import androidx.compose.material.icons.materialIcon
import androidx.compose.material.icons.materialPath
import androidx.compose.ui.graphics.vector.ImageVector

public val Icons.Outlined.Workspaces: ImageVector
    get() {
        if (_workspaces != null) {
            return _workspaces!!
        }
        _workspaces = materialIcon(name = "Outlined.Workspaces") {
            materialPath {
                moveTo(6.0f, 15.0f)
                curveToRelative(1.1f, 0.0f, 2.0f, 0.9f, 2.0f, 2.0f)
                reflectiveCurveToRelative(-0.9f, 2.0f, -2.0f, 2.0f)
                reflectiveCurveToRelative(-2.0f, -0.9f, -2.0f, -2.0f)
                reflectiveCurveTo(4.9f, 15.0f, 6.0f, 15.0f)
                moveTo(6.0f, 13.0f)
                curveToRelative(-2.2f, 0.0f, -4.0f, 1.8f, -4.0f, 4.0f)
                reflectiveCurveToRelative(1.8f, 4.0f, 4.0f, 4.0f)
                reflectiveCurveToRelative(4.0f, -1.8f, 4.0f, -4.0f)
                reflectiveCurveTo(8.2f, 13.0f, 6.0f, 13.0f)
                close()
                moveTo(12.0f, 5.0f)
                curveToRelative(1.1f, 0.0f, 2.0f, 0.9f, 2.0f, 2.0f)
                reflectiveCurveToRelative(-0.9f, 2.0f, -2.0f, 2.0f)
                reflectiveCurveToRelative(-2.0f, -0.9f, -2.0f, -2.0f)
                reflectiveCurveTo(10.9f, 5.0f, 12.0f, 5.0f)
                moveTo(12.0f, 3.0f)
                curveTo(9.8f, 3.0f, 8.0f, 4.8f, 8.0f, 7.0f)
                reflectiveCurveToRelative(1.8f, 4.0f, 4.0f, 4.0f)
                reflectiveCurveToRelative(4.0f, -1.8f, 4.0f, -4.0f)
                reflectiveCurveTo(14.2f, 3.0f, 12.0f, 3.0f)
                close()
                moveTo(18.0f, 15.0f)
                curveToRelative(1.1f, 0.0f, 2.0f, 0.9f, 2.0f, 2.0f)
                reflectiveCurveToRelative(-0.9f, 2.0f, -2.0f, 2.0f)
                reflectiveCurveToRelative(-2.0f, -0.9f, -2.0f, -2.0f)
                reflectiveCurveTo(16.9f, 15.0f, 18.0f, 15.0f)
                moveTo(18.0f, 13.0f)
                curveToRelative(-2.2f, 0.0f, -4.0f, 1.8f, -4.0f, 4.0f)
                reflectiveCurveToRelative(1.8f, 4.0f, 4.0f, 4.0f)
                reflectiveCurveToRelative(4.0f, -1.8f, 4.0f, -4.0f)
                reflectiveCurveTo(20.2f, 13.0f, 18.0f, 13.0f)
                close()
            }
        }
        return _workspaces!!
    }

private var _workspaces: ImageVector? = null
