/*
 * Copyright 2022 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package androidx.compose.material.icons.outlined

import androidx.compose.material.icons.Icons
import androidx.compose.material.icons.materialIcon
import androidx.compose.material.icons.materialPath
import androidx.compose.ui.graphics.vector.ImageVector

public val Icons.Outlined.Tornado: ImageVector
    get() {
        if (_tornado != null) {
            return _tornado!!
        }
        _tornado = materialIcon(name = "Outlined.Tornado") {
            materialPath {
                moveTo(23.0f, 3.0f)
                horizontalLineTo(1.0f)
                lineToRelative(11.0f, 19.0f)
                lineTo(23.0f, 3.0f)
                close()
                moveTo(19.53f, 5.0f)
                lineToRelative(-1.74f, 3.0f)
                horizontalLineTo(6.21f)
                lineTo(4.47f, 5.0f)
                horizontalLineTo(19.53f)
                close()
                moveTo(10.26f, 15.0f)
                horizontalLineToRelative(3.48f)
                lineTo(12.0f, 18.01f)
                lineTo(10.26f, 15.0f)
                close()
                moveTo(14.9f, 13.0f)
                horizontalLineTo(9.1f)
                lineToRelative(-1.74f, -3.0f)
                horizontalLineToRelative(9.27f)
                lineTo(14.9f, 13.0f)
                close()
            }
        }
        return _tornado!!
    }

private var _tornado: ImageVector? = null
