/*
 * Copyright 2022 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package androidx.compose.material.icons.outlined

import androidx.compose.material.icons.Icons
import androidx.compose.material.icons.materialIcon
import androidx.compose.material.icons.materialPath
import androidx.compose.ui.graphics.vector.ImageVector

public val Icons.Outlined.ShuffleOn: ImageVector
    get() {
        if (_shuffleOn != null) {
            return _shuffleOn!!
        }
        _shuffleOn = materialIcon(name = "Outlined.ShuffleOn") {
            materialPath {
                moveTo(21.0f, 1.0f)
                horizontalLineTo(3.0f)
                curveTo(1.9f, 1.0f, 1.0f, 1.9f, 1.0f, 3.0f)
                verticalLineToRelative(18.0f)
                curveToRelative(0.0f, 1.1f, 0.9f, 2.0f, 2.0f, 2.0f)
                horizontalLineToRelative(18.0f)
                curveToRelative(1.1f, 0.0f, 2.0f, -0.9f, 2.0f, -2.0f)
                verticalLineTo(3.0f)
                curveTo(23.0f, 1.9f, 22.1f, 1.0f, 21.0f, 1.0f)
                close()
                moveTo(5.41f, 4.0f)
                lineToRelative(5.18f, 5.17f)
                lineToRelative(-1.41f, 1.42f)
                lineTo(4.0f, 5.42f)
                lineTo(5.41f, 4.0f)
                close()
                moveTo(20.0f, 20.0f)
                horizontalLineToRelative(-6.0f)
                verticalLineToRelative(-2.0f)
                horizontalLineToRelative(2.61f)
                lineToRelative(-3.2f, -3.2f)
                lineToRelative(1.42f, -1.42f)
                lineToRelative(3.13f, 3.13f)
                lineTo(18.0f, 16.55f)
                verticalLineTo(14.0f)
                horizontalLineToRelative(2.0f)
                verticalLineTo(20.0f)
                close()
                moveTo(20.0f, 10.0f)
                horizontalLineToRelative(-2.0f)
                verticalLineTo(7.42f)
                lineTo(5.41f, 20.0f)
                lineTo(4.0f, 18.59f)
                lineTo(16.58f, 6.0f)
                horizontalLineTo(14.0f)
                verticalLineTo(4.0f)
                horizontalLineToRelative(6.0f)
                verticalLineTo(10.0f)
                close()
            }
        }
        return _shuffleOn!!
    }

private var _shuffleOn: ImageVector? = null
