/*
 * Copyright 2022 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package androidx.compose.material.icons.outlined

import androidx.compose.material.icons.Icons
import androidx.compose.material.icons.materialIcon
import androidx.compose.material.icons.materialPath
import androidx.compose.ui.graphics.vector.ImageVector

public val Icons.Outlined.SendTimeExtension: ImageVector
    get() {
        if (_sendTimeExtension != null) {
            return _sendTimeExtension!!
        }
        _sendTimeExtension = materialIcon(name = "Outlined.SendTimeExtension") {
            materialPath {
                moveTo(18.0f, 6.0f)
                verticalLineToRelative(6.26f)
                lineToRelative(2.0f, 1.0f)
                verticalLineTo(6.0f)
                curveToRelative(0.0f, -1.1f, -0.9f, -2.0f, -2.0f, -2.0f)
                horizontalLineToRelative(-4.0f)
                curveToRelative(0.0f, -1.38f, -1.12f, -2.5f, -2.5f, -2.5f)
                reflectiveCurveTo(9.0f, 2.62f, 9.0f, 4.0f)
                horizontalLineTo(5.01f)
                curveToRelative(-1.1f, 0.0f, -2.0f, 0.9f, -2.0f, 2.0f)
                verticalLineToRelative(3.8f)
                curveTo(5.7f, 9.8f, 6.0f, 11.96f, 6.0f, 12.5f)
                curveToRelative(0.0f, 0.54f, -0.29f, 2.7f, -3.0f, 2.7f)
                verticalLineTo(19.0f)
                curveToRelative(0.0f, 1.1f, 0.9f, 2.0f, 2.0f, 2.0f)
                horizontalLineToRelative(3.8f)
                curveToRelative(0.0f, -2.16f, 1.37f, -2.78f, 2.2f, -2.94f)
                verticalLineToRelative(-2.03f)
                curveTo(9.57f, 16.2f, 7.85f, 17.07f, 7.13f, 19.0f)
                horizontalLineTo(5.0f)
                verticalLineToRelative(-2.13f)
                curveToRelative(2.17f, -0.8f, 3.0f, -2.87f, 3.0f, -4.37f)
                curveToRelative(0.0f, -1.49f, -0.83f, -3.56f, -2.99f, -4.37f)
                verticalLineTo(6.0f)
                horizontalLineTo(11.0f)
                verticalLineTo(4.0f)
                curveToRelative(0.0f, -0.28f, 0.22f, -0.5f, 0.5f, -0.5f)
                reflectiveCurveTo(12.0f, 3.72f, 12.0f, 4.0f)
                verticalLineToRelative(2.0f)
                horizontalLineTo(18.0f)
                close()
            }
            materialPath {
                moveTo(13.0f, 12.0f)
                lineToRelative(0.0f, 4.0f)
                lineToRelative(4.0f, 1.0f)
                lineToRelative(-4.0f, 1.0f)
                lineToRelative(0.0f, 4.0f)
                lineToRelative(10.0f, -5.0f)
                close()
            }
        }
        return _sendTimeExtension!!
    }

private var _sendTimeExtension: ImageVector? = null
