/*
 * Copyright 2022 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package androidx.compose.material.icons.outlined

import androidx.compose.material.icons.Icons
import androidx.compose.material.icons.materialIcon
import androidx.compose.material.icons.materialPath
import androidx.compose.ui.graphics.vector.ImageVector

public val Icons.Outlined.RunCircle: ImageVector
    get() {
        if (_runCircle != null) {
            return _runCircle!!
        }
        _runCircle = materialIcon(name = "Outlined.RunCircle") {
            materialPath {
                moveTo(12.0f, 2.0f)
                curveTo(6.48f, 2.0f, 2.0f, 6.48f, 2.0f, 12.0f)
                curveToRelative(0.0f, 5.52f, 4.48f, 10.0f, 10.0f, 10.0f)
                reflectiveCurveToRelative(10.0f, -4.48f, 10.0f, -10.0f)
                curveTo(22.0f, 6.48f, 17.52f, 2.0f, 12.0f, 2.0f)
                close()
                moveTo(12.0f, 20.0f)
                curveToRelative(-4.42f, 0.0f, -8.0f, -3.58f, -8.0f, -8.0f)
                reflectiveCurveToRelative(3.58f, -8.0f, 8.0f, -8.0f)
                reflectiveCurveToRelative(8.0f, 3.58f, 8.0f, 8.0f)
                reflectiveCurveTo(16.42f, 20.0f, 12.0f, 20.0f)
                close()
            }
            materialPath {
                moveTo(13.54f, 8.97f)
                curveToRelative(-0.23f, -0.47f, -0.76f, -0.71f, -1.26f, -0.53f)
                lineTo(9.0f, 9.65f)
                verticalLineTo(12.0f)
                horizontalLineToRelative(1.0f)
                verticalLineToRelative(-1.65f)
                lineToRelative(1.54f, -0.57f)
                lineToRelative(-0.96f, 4.89f)
                lineTo(7.8f, 14.1f)
                lineToRelative(-0.2f, 0.98f)
                lineToRelative(3.76f, 0.77f)
                lineToRelative(0.52f, -2.64f)
                lineTo(13.0f, 14.42f)
                verticalLineTo(18.0f)
                horizontalLineToRelative(1.0f)
                verticalLineToRelative(-3.97f)
                lineToRelative(-1.32f, -1.44f)
                lineToRelative(0.41f, -2.35f)
                curveTo(13.99f, 11.46f, 15.3f, 12.0f, 16.0f, 12.0f)
                verticalLineToRelative(-1.0f)
                curveTo(15.59f, 11.0f, 14.37f, 10.67f, 13.54f, 8.97f)
                close()
            }
            materialPath {
                moveTo(13.5f, 7.0f)
                moveToRelative(-1.0f, 0.0f)
                arcToRelative(1.0f, 1.0f, 0.0f, true, true, 2.0f, 0.0f)
                arcToRelative(1.0f, 1.0f, 0.0f, true, true, -2.0f, 0.0f)
            }
        }
        return _runCircle!!
    }

private var _runCircle: ImageVector? = null
