/*
 * Copyright 2022 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package androidx.compose.material.icons.outlined

import androidx.compose.material.icons.Icons
import androidx.compose.material.icons.materialIcon
import androidx.compose.material.icons.materialPath
import androidx.compose.ui.graphics.vector.ImageVector

public val Icons.Outlined.Rotate90DegreesCw: ImageVector
    get() {
        if (_rotate90DegreesCw != null) {
            return _rotate90DegreesCw!!
        }
        _rotate90DegreesCw = materialIcon(name = "Outlined.Rotate90DegreesCw") {
            materialPath {
                moveTo(2.0f, 13.0f)
                curveToRelative(0.0f, 4.97f, 4.03f, 9.0f, 9.0f, 9.0f)
                curveToRelative(1.76f, 0.0f, 3.4f, -0.51f, 4.79f, -1.38f)
                lineToRelative(-1.46f, -1.46f)
                curveTo(13.34f, 19.69f, 12.2f, 20.0f, 11.0f, 20.0f)
                curveToRelative(-3.86f, 0.0f, -7.0f, -3.14f, -7.0f, -7.0f)
                reflectiveCurveToRelative(3.14f, -7.0f, 7.0f, -7.0f)
                horizontalLineToRelative(0.17f)
                lineTo(9.59f, 7.59f)
                lineTo(11.0f, 9.0f)
                lineToRelative(4.0f, -4.0f)
                lineToRelative(-4.0f, -4.0f)
                lineTo(9.58f, 2.41f)
                lineTo(11.17f, 4.0f)
                horizontalLineTo(11.0f)
                curveTo(6.03f, 4.0f, 2.0f, 8.03f, 2.0f, 13.0f)
                close()
                moveTo(11.0f, 13.0f)
                lineToRelative(6.0f, 6.0f)
                lineToRelative(6.0f, -6.0f)
                lineToRelative(-6.0f, -6.0f)
                lineTo(11.0f, 13.0f)
                close()
                moveTo(17.0f, 16.17f)
                lineTo(13.83f, 13.0f)
                lineTo(17.0f, 9.83f)
                lineTo(20.17f, 13.0f)
                lineTo(17.0f, 16.17f)
                close()
            }
        }
        return _rotate90DegreesCw!!
    }

private var _rotate90DegreesCw: ImageVector? = null
