/*
 * Copyright 2022 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package androidx.compose.material.icons.outlined

import androidx.compose.material.icons.Icons
import androidx.compose.material.icons.materialIcon
import androidx.compose.material.icons.materialPath
import androidx.compose.ui.graphics.vector.ImageVector

public val Icons.Outlined.RollerSkating: ImageVector
    get() {
        if (_rollerSkating != null) {
            return _rollerSkating!!
        }
        _rollerSkating = materialIcon(name = "Outlined.RollerSkating") {
            materialPath {
                moveTo(20.0f, 12.0f)
                curveToRelative(0.0f, -1.79f, -1.19f, -3.34f, -2.91f, -3.82f)
                lineToRelative(-2.62f, -0.74f)
                curveTo(13.62f, 7.19f, 13.0f, 6.39f, 13.0f, 5.5f)
                verticalLineTo(1.0f)
                horizontalLineTo(4.0f)
                verticalLineToRelative(15.0f)
                horizontalLineToRelative(16.0f)
                verticalLineTo(12.0f)
                close()
                moveTo(18.0f, 14.0f)
                horizontalLineTo(6.0f)
                verticalLineTo(3.0f)
                horizontalLineToRelative(5.0f)
                verticalLineToRelative(1.0f)
                horizontalLineTo(9.5f)
                curveTo(9.22f, 4.0f, 9.0f, 4.22f, 9.0f, 4.5f)
                curveTo(9.0f, 4.78f, 9.22f, 5.0f, 9.5f, 5.0f)
                horizontalLineTo(11.0f)
                lineToRelative(0.1f, 1.0f)
                horizontalLineTo(9.5f)
                curveTo(9.22f, 6.0f, 9.0f, 6.22f, 9.0f, 6.5f)
                curveTo(9.0f, 6.78f, 9.22f, 7.0f, 9.5f, 7.0f)
                horizontalLineToRelative(1.81f)
                curveToRelative(0.45f, 1.12f, 1.4f, 2.01f, 2.6f, 2.36f)
                lineToRelative(2.62f, 0.73f)
                curveTo(17.4f, 10.33f, 18.0f, 11.1f, 18.0f, 12.0f)
                verticalLineTo(14.0f)
                close()
                moveTo(5.0f, 17.0f)
                curveToRelative(-1.66f, 0.0f, -3.0f, 1.34f, -3.0f, 3.0f)
                reflectiveCurveToRelative(1.34f, 3.0f, 3.0f, 3.0f)
                reflectiveCurveToRelative(3.0f, -1.34f, 3.0f, -3.0f)
                reflectiveCurveTo(6.66f, 17.0f, 5.0f, 17.0f)
                close()
                moveTo(5.0f, 21.0f)
                curveToRelative(-0.55f, 0.0f, -1.0f, -0.45f, -1.0f, -1.0f)
                curveToRelative(0.0f, -0.55f, 0.45f, -1.0f, 1.0f, -1.0f)
                reflectiveCurveToRelative(1.0f, 0.45f, 1.0f, 1.0f)
                curveTo(6.0f, 20.55f, 5.55f, 21.0f, 5.0f, 21.0f)
                close()
                moveTo(19.0f, 17.0f)
                curveToRelative(-1.66f, 0.0f, -3.0f, 1.34f, -3.0f, 3.0f)
                reflectiveCurveToRelative(1.34f, 3.0f, 3.0f, 3.0f)
                reflectiveCurveToRelative(3.0f, -1.34f, 3.0f, -3.0f)
                reflectiveCurveTo(20.66f, 17.0f, 19.0f, 17.0f)
                close()
                moveTo(19.0f, 21.0f)
                curveToRelative(-0.55f, 0.0f, -1.0f, -0.45f, -1.0f, -1.0f)
                curveToRelative(0.0f, -0.55f, 0.45f, -1.0f, 1.0f, -1.0f)
                reflectiveCurveToRelative(1.0f, 0.45f, 1.0f, 1.0f)
                curveTo(20.0f, 20.55f, 19.55f, 21.0f, 19.0f, 21.0f)
                close()
                moveTo(12.0f, 17.0f)
                curveToRelative(-1.66f, 0.0f, -3.0f, 1.34f, -3.0f, 3.0f)
                reflectiveCurveToRelative(1.34f, 3.0f, 3.0f, 3.0f)
                reflectiveCurveToRelative(3.0f, -1.34f, 3.0f, -3.0f)
                reflectiveCurveTo(13.66f, 17.0f, 12.0f, 17.0f)
                close()
                moveTo(12.0f, 21.0f)
                curveToRelative(-0.55f, 0.0f, -1.0f, -0.45f, -1.0f, -1.0f)
                curveToRelative(0.0f, -0.55f, 0.45f, -1.0f, 1.0f, -1.0f)
                reflectiveCurveToRelative(1.0f, 0.45f, 1.0f, 1.0f)
                curveTo(13.0f, 20.55f, 12.55f, 21.0f, 12.0f, 21.0f)
                close()
            }
        }
        return _rollerSkating!!
    }

private var _rollerSkating: ImageVector? = null
