/*
 * Copyright 2022 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package androidx.compose.material.icons.outlined

import androidx.compose.material.icons.Icons
import androidx.compose.material.icons.materialIcon
import androidx.compose.material.icons.materialPath
import androidx.compose.ui.graphics.vector.ImageVector

public val Icons.Outlined.NoFood: ImageVector
    get() {
        if (_noFood != null) {
            return _noFood!!
        }
        _noFood = materialIcon(name = "Outlined.NoFood") {
            materialPath {
                moveTo(1.0f, 21.0f)
                horizontalLineToRelative(15.01f)
                verticalLineToRelative(0.98f)
                curveToRelative(0.0f, 0.56f, -0.45f, 1.01f, -1.01f, 1.01f)
                horizontalLineTo(2.01f)
                curveTo(1.45f, 22.99f, 1.0f, 22.54f, 1.0f, 21.98f)
                verticalLineTo(21.0f)
                close()
                moveTo(20.49f, 23.31f)
                lineTo(16.0f, 18.83f)
                verticalLineTo(19.0f)
                horizontalLineTo(1.0f)
                verticalLineToRelative(-2.0f)
                horizontalLineToRelative(13.17f)
                lineToRelative(-2.0f, -2.0f)
                horizontalLineTo(1.0f)
                curveToRelative(0.0f, -3.24f, 2.46f, -5.17f, 5.38f, -5.79f)
                lineToRelative(-5.7f, -5.7f)
                lineTo(2.1f, 2.1f)
                lineTo(13.0f, 13.0f)
                lineToRelative(2.0f, 2.0f)
                lineToRelative(6.9f, 6.9f)
                lineTo(20.49f, 23.31f)
                close()
                moveTo(10.17f, 13.0f)
                lineToRelative(-2.0f, -2.0f)
                curveToRelative(-1.42f, 0.06f, -3.52f, 0.56f, -4.55f, 2.0f)
                horizontalLineTo(10.17f)
                close()
                moveTo(23.0f, 5.0f)
                horizontalLineToRelative(-5.0f)
                verticalLineTo(1.0f)
                horizontalLineToRelative(-2.0f)
                verticalLineToRelative(4.0f)
                horizontalLineToRelative(-5.0f)
                lineToRelative(0.23f, 2.0f)
                horizontalLineToRelative(9.56f)
                lineToRelative(-1.0f, 9.97f)
                lineToRelative(1.83f, 1.83f)
                lineTo(23.0f, 5.0f)
                close()
            }
        }
        return _noFood!!
    }

private var _noFood: ImageVector? = null
