/*
 * Copyright 2022 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package androidx.compose.material.icons.outlined

import androidx.compose.material.icons.Icons
import androidx.compose.material.icons.materialIcon
import androidx.compose.material.icons.materialPath
import androidx.compose.ui.graphics.vector.ImageVector

public val Icons.Outlined.NearbyError: ImageVector
    get() {
        if (_nearbyError != null) {
            return _nearbyError!!
        }
        _nearbyError = materialIcon(name = "Outlined.NearbyError") {
            materialPath {
                moveTo(12.0f, 7.57f)
                lineToRelative(4.42f, 4.42f)
                lineTo(12.0f, 16.41f)
                lineToRelative(-4.42f, -4.42f)
                lineTo(12.0f, 7.57f)
                close()
                moveTo(12.0f, 19.19f)
                lineToRelative(-7.2f, -7.2f)
                lineToRelative(7.2f, -7.2f)
                lineToRelative(6.0f, 6.0f)
                verticalLineTo(7.16f)
                lineToRelative(-4.58f, -4.58f)
                curveToRelative(-0.78f, -0.78f, -2.05f, -0.78f, -2.83f, 0.0f)
                lineToRelative(-8.01f, 8.0f)
                curveToRelative(-0.78f, 0.78f, -0.78f, 2.05f, 0.0f, 2.83f)
                lineToRelative(8.01f, 8.0f)
                curveToRelative(0.78f, 0.78f, 2.05f, 0.78f, 2.83f, 0.0f)
                lineTo(18.0f, 16.82f)
                verticalLineToRelative(-3.63f)
                lineTo(12.0f, 19.19f)
                close()
                moveTo(20.0f, 20.0f)
                horizontalLineToRelative(2.0f)
                verticalLineToRelative(2.0f)
                horizontalLineToRelative(-2.0f)
                verticalLineTo(20.0f)
                close()
                moveTo(22.0f, 10.0f)
                horizontalLineToRelative(-2.0f)
                verticalLineToRelative(8.0f)
                horizontalLineToRelative(2.0f)
                verticalLineTo(10.0f)
            }
        }
        return _nearbyError!!
    }

private var _nearbyError: ImageVector? = null
