/*
 * Copyright 2022 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package androidx.compose.material.icons.outlined

import androidx.compose.material.icons.Icons
import androidx.compose.material.icons.materialIcon
import androidx.compose.material.icons.materialPath
import androidx.compose.ui.graphics.vector.ImageVector

public val Icons.Outlined.MovieFilter: ImageVector
    get() {
        if (_movieFilter != null) {
            return _movieFilter!!
        }
        _movieFilter = materialIcon(name = "Outlined.MovieFilter") {
            materialPath {
                moveTo(10.0f, 11.0f)
                lineToRelative(-0.94f, 2.06f)
                lineTo(7.0f, 14.0f)
                lineToRelative(2.06f, 0.94f)
                lineTo(10.0f, 17.0f)
                lineToRelative(0.94f, -2.06f)
                lineTo(13.0f, 14.0f)
                lineToRelative(-2.06f, -0.94f)
                close()
                moveTo(18.01f, 4.0f)
                lineToRelative(2.0f, 4.0f)
                horizontalLineToRelative(-3.0f)
                lineToRelative(-2.0f, -4.0f)
                horizontalLineToRelative(-2.0f)
                lineToRelative(2.0f, 4.0f)
                horizontalLineToRelative(-3.0f)
                lineToRelative(-2.0f, -4.0f)
                horizontalLineToRelative(-2.0f)
                lineToRelative(2.0f, 4.0f)
                horizontalLineToRelative(-3.0f)
                lineToRelative(-2.0f, -4.0f)
                horizontalLineToRelative(-1.0f)
                curveToRelative(-1.1f, 0.0f, -1.99f, 0.9f, -1.99f, 2.0f)
                lineToRelative(-0.01f, 12.0f)
                curveToRelative(0.0f, 1.1f, 0.9f, 2.0f, 2.0f, 2.0f)
                horizontalLineToRelative(16.0f)
                curveToRelative(1.1f, 0.0f, 1.99f, -0.9f, 1.99f, -2.0f)
                lineTo(22.0f, 4.0f)
                horizontalLineToRelative(-3.99f)
                close()
                moveTo(20.01f, 18.0f)
                horizontalLineToRelative(-16.0f)
                lineTo(4.01f, 6.47f)
                lineTo(5.77f, 10.0f)
                lineTo(16.0f, 10.0f)
                lineToRelative(-0.63f, 1.37f)
                lineTo(14.0f, 12.0f)
                lineToRelative(1.37f, 0.63f)
                lineTo(16.0f, 14.0f)
                lineToRelative(0.63f, -1.37f)
                lineTo(18.0f, 12.0f)
                lineToRelative(-1.37f, -0.63f)
                lineTo(16.0f, 10.0f)
                horizontalLineToRelative(4.01f)
                verticalLineToRelative(8.0f)
                close()
            }
        }
        return _movieFilter!!
    }

private var _movieFilter: ImageVector? = null
