/*
 * Copyright 2022 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package androidx.compose.material.icons.outlined

import androidx.compose.material.icons.Icons
import androidx.compose.material.icons.materialIcon
import androidx.compose.material.icons.materialPath
import androidx.compose.ui.graphics.vector.ImageVector

public val Icons.Outlined.MicExternalOn: ImageVector
    get() {
        if (_micExternalOn != null) {
            return _micExternalOn!!
        }
        _micExternalOn = materialIcon(name = "Outlined.MicExternalOn") {
            materialPath {
                moveTo(9.22f, 7.0f)
                curveTo(9.7f, 6.47f, 10.0f, 5.77f, 10.0f, 5.0f)
                curveToRelative(0.0f, -1.66f, -1.34f, -3.0f, -3.0f, -3.0f)
                reflectiveCurveTo(4.0f, 3.34f, 4.0f, 5.0f)
                curveToRelative(0.0f, 0.77f, 0.3f, 1.47f, 0.78f, 2.0f)
                horizontalLineTo(9.22f)
                close()
            }
            materialPath {
                moveTo(16.0f, 2.0f)
                curveToRelative(-2.21f, 0.0f, -4.0f, 1.79f, -4.0f, 4.0f)
                verticalLineToRelative(12.0f)
                curveToRelative(0.0f, 1.1f, -0.9f, 2.0f, -2.0f, 2.0f)
                reflectiveCurveToRelative(-2.0f, -0.9f, -2.0f, -2.0f)
                horizontalLineToRelative(1.0f)
                lineToRelative(1.0f, -10.0f)
                horizontalLineTo(4.0f)
                lineToRelative(1.0f, 10.0f)
                horizontalLineToRelative(1.0f)
                curveToRelative(0.0f, 2.21f, 1.79f, 4.0f, 4.0f, 4.0f)
                reflectiveCurveToRelative(4.0f, -1.79f, 4.0f, -4.0f)
                verticalLineTo(6.0f)
                curveToRelative(0.0f, -1.1f, 0.9f, -2.0f, 2.0f, -2.0f)
                reflectiveCurveToRelative(2.0f, 0.9f, 2.0f, 2.0f)
                verticalLineToRelative(16.0f)
                horizontalLineToRelative(2.0f)
                verticalLineTo(6.0f)
                curveTo(20.0f, 3.79f, 18.21f, 2.0f, 16.0f, 2.0f)
                close()
                moveTo(7.19f, 16.0f)
                horizontalLineTo(6.81f)
                lineToRelative(-0.6f, -6.0f)
                horizontalLineToRelative(1.58f)
                lineTo(7.19f, 16.0f)
                close()
            }
        }
        return _micExternalOn!!
    }

private var _micExternalOn: ImageVector? = null
