/*
 * Copyright 2022 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package androidx.compose.material.icons.outlined

import androidx.compose.material.icons.Icons
import androidx.compose.material.icons.materialIcon
import androidx.compose.material.icons.materialPath
import androidx.compose.ui.graphics.vector.ImageVector

public val Icons.Outlined.LocalFlorist: ImageVector
    get() {
        if (_localFlorist != null) {
            return _localFlorist!!
        }
        _localFlorist = materialIcon(name = "Outlined.LocalFlorist") {
            materialPath {
                moveTo(8.66f, 13.07f)
                curveToRelative(0.15f, 0.0f, 0.29f, -0.01f, 0.43f, -0.03f)
                curveTo(9.56f, 14.19f, 10.69f, 15.0f, 12.0f, 15.0f)
                reflectiveCurveToRelative(2.44f, -0.81f, 2.91f, -1.96f)
                curveToRelative(0.14f, 0.02f, 0.29f, 0.03f, 0.43f, 0.03f)
                curveToRelative(1.73f, 0.0f, 3.14f, -1.41f, 3.14f, -3.14f)
                curveToRelative(0.0f, -0.71f, -0.25f, -1.39f, -0.67f, -1.93f)
                curveToRelative(0.43f, -0.54f, 0.67f, -1.22f, 0.67f, -1.93f)
                curveToRelative(0.0f, -1.73f, -1.41f, -3.14f, -3.14f, -3.14f)
                curveToRelative(-0.15f, 0.0f, -0.29f, 0.01f, -0.43f, 0.03f)
                curveTo(14.44f, 1.81f, 13.31f, 1.0f, 12.0f, 1.0f)
                reflectiveCurveToRelative(-2.44f, 0.81f, -2.91f, 1.96f)
                curveToRelative(-0.14f, -0.02f, -0.29f, -0.03f, -0.43f, -0.03f)
                curveToRelative(-1.73f, 0.0f, -3.14f, 1.41f, -3.14f, 3.14f)
                curveToRelative(0.0f, 0.71f, 0.25f, 1.39f, 0.67f, 1.93f)
                curveToRelative(-0.43f, 0.54f, -0.68f, 1.22f, -0.68f, 1.93f)
                curveToRelative(0.0f, 1.73f, 1.41f, 3.14f, 3.15f, 3.14f)
                close()
                moveTo(12.0f, 13.0f)
                curveToRelative(-0.62f, 0.0f, -1.12f, -0.49f, -1.14f, -1.1f)
                lineToRelative(0.12f, -1.09f)
                curveToRelative(0.32f, 0.12f, 0.66f, 0.19f, 1.02f, 0.19f)
                reflectiveCurveToRelative(0.71f, -0.07f, 1.03f, -0.19f)
                lineToRelative(0.11f, 1.09f)
                curveToRelative(-0.02f, 0.61f, -0.52f, 1.1f, -1.14f, 1.1f)
                close()
                moveTo(15.34f, 11.07f)
                curveToRelative(-0.24f, 0.0f, -0.46f, -0.07f, -0.64f, -0.2f)
                lineToRelative(-0.81f, -0.57f)
                curveToRelative(0.55f, -0.45f, 0.94f, -1.09f, 1.06f, -1.83f)
                lineToRelative(0.88f, 0.42f)
                curveToRelative(0.4f, 0.19f, 0.66f, 0.59f, 0.66f, 1.03f)
                curveToRelative(0.0f, 0.64f, -0.52f, 1.15f, -1.15f, 1.15f)
                close()
                moveTo(14.69f, 5.13f)
                curveToRelative(0.2f, -0.13f, 0.42f, -0.2f, 0.65f, -0.2f)
                curveToRelative(0.63f, 0.0f, 1.14f, 0.51f, 1.14f, 1.14f)
                curveToRelative(0.0f, 0.44f, -0.25f, 0.83f, -0.66f, 1.03f)
                lineToRelative(-0.88f, 0.42f)
                curveToRelative(-0.12f, -0.74f, -0.51f, -1.38f, -1.07f, -1.83f)
                lineToRelative(0.82f, -0.56f)
                close()
                moveTo(12.0f, 3.0f)
                curveToRelative(0.62f, 0.0f, 1.12f, 0.49f, 1.14f, 1.1f)
                lineToRelative(-0.11f, 1.09f)
                curveTo(12.71f, 5.07f, 12.36f, 5.0f, 12.0f, 5.0f)
                reflectiveCurveToRelative(-0.7f, 0.07f, -1.02f, 0.19f)
                lineToRelative(-0.12f, -1.09f)
                curveToRelative(0.02f, -0.61f, 0.52f, -1.1f, 1.14f, -1.1f)
                close()
                moveTo(8.66f, 4.93f)
                curveToRelative(0.24f, 0.0f, 0.46f, 0.07f, 0.64f, 0.2f)
                lineToRelative(0.81f, 0.56f)
                curveToRelative(-0.55f, 0.45f, -0.94f, 1.09f, -1.06f, 1.83f)
                lineToRelative(-0.88f, -0.42f)
                curveToRelative(-0.4f, -0.2f, -0.66f, -0.59f, -0.66f, -1.03f)
                curveToRelative(0.0f, -0.63f, 0.52f, -1.14f, 1.15f, -1.14f)
                close()
                moveTo(8.17f, 8.9f)
                lineToRelative(0.88f, -0.42f)
                curveToRelative(0.12f, 0.74f, 0.51f, 1.38f, 1.07f, 1.83f)
                lineToRelative(-0.81f, 0.55f)
                curveToRelative(-0.2f, 0.13f, -0.42f, 0.2f, -0.65f, 0.2f)
                curveToRelative(-0.63f, 0.0f, -1.14f, -0.51f, -1.14f, -1.14f)
                curveToRelative(-0.01f, -0.43f, 0.25f, -0.82f, 0.65f, -1.02f)
                close()
                moveTo(12.0f, 22.0f)
                curveToRelative(4.97f, 0.0f, 9.0f, -4.03f, 9.0f, -9.0f)
                curveToRelative(-4.97f, 0.0f, -9.0f, 4.03f, -9.0f, 9.0f)
                close()
                moveTo(14.44f, 19.56f)
                curveToRelative(0.71f, -1.9f, 2.22f, -3.42f, 4.12f, -4.12f)
                curveToRelative(-0.71f, 1.9f, -2.22f, 3.41f, -4.12f, 4.12f)
                close()
                moveTo(3.0f, 13.0f)
                curveToRelative(0.0f, 4.97f, 4.03f, 9.0f, 9.0f, 9.0f)
                curveToRelative(0.0f, -4.97f, -4.03f, -9.0f, -9.0f, -9.0f)
                close()
                moveTo(5.44f, 15.44f)
                curveToRelative(1.9f, 0.71f, 3.42f, 2.22f, 4.12f, 4.12f)
                curveToRelative(-1.9f, -0.71f, -3.41f, -2.22f, -4.12f, -4.12f)
                close()
            }
        }
        return _localFlorist!!
    }

private var _localFlorist: ImageVector? = null
