/*
 * Copyright 2022 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package androidx.compose.material.icons.outlined

import androidx.compose.material.icons.Icons
import androidx.compose.material.icons.materialIcon
import androidx.compose.material.icons.materialPath
import androidx.compose.ui.graphics.vector.ImageVector

public val Icons.Outlined.Kitesurfing: ImageVector
    get() {
        if (_kitesurfing != null) {
            return _kitesurfing!!
        }
        _kitesurfing = materialIcon(name = "Outlined.Kitesurfing") {
            materialPath {
                moveTo(6.0f, 3.0f)
                curveToRelative(0.0f, -1.1f, 0.9f, -2.0f, 2.0f, -2.0f)
                reflectiveCurveToRelative(2.0f, 0.9f, 2.0f, 2.0f)
                curveToRelative(0.0f, 1.1f, -0.9f, 2.0f, -2.0f, 2.0f)
                reflectiveCurveTo(6.0f, 4.1f, 6.0f, 3.0f)
                close()
                moveTo(20.06f, 1.0f)
                horizontalLineToRelative(-2.12f)
                lineTo(15.5f, 3.44f)
                lineToRelative(1.06f, 1.06f)
                lineTo(20.06f, 1.0f)
                close()
                moveTo(22.0f, 23.0f)
                verticalLineToRelative(-2.0f)
                horizontalLineToRelative(-1.0f)
                curveToRelative(-1.04f, 0.0f, -2.08f, -0.35f, -3.0f, -1.0f)
                curveToRelative(-1.83f, 1.3f, -4.17f, 1.3f, -6.0f, 0.0f)
                curveToRelative(-1.83f, 1.3f, -4.17f, 1.3f, -6.0f, 0.0f)
                curveToRelative(-0.91f, 0.65f, -1.96f, 1.0f, -3.0f, 1.0f)
                horizontalLineTo(2.0f)
                lineToRelative(0.0f, 2.0f)
                horizontalLineToRelative(1.0f)
                curveToRelative(1.03f, 0.0f, 2.05f, -0.25f, 3.0f, -0.75f)
                curveToRelative(1.89f, 1.0f, 4.11f, 1.0f, 6.0f, 0.0f)
                curveToRelative(1.89f, 1.0f, 4.11f, 1.0f, 6.0f, 0.0f)
                horizontalLineToRelative(0.0f)
                curveToRelative(0.95f, 0.5f, 1.97f, 0.75f, 3.0f, 0.75f)
                horizontalLineTo(22.0f)
                close()
                moveTo(21.0f, 13.28f)
                curveToRelative(0.0f, 1.44f, -2.19f, 3.62f, -5.04f, 5.58f)
                curveTo(15.65f, 18.95f, 15.33f, 19.0f, 15.0f, 19.0f)
                curveToRelative(-1.2f, 0.0f, -2.27f, -0.66f, -3.0f, -1.5f)
                curveToRelative(-0.73f, 0.84f, -1.8f, 1.5f, -3.0f, 1.5f)
                curveToRelative(-0.94f, 0.0f, -1.81f, -0.41f, -2.49f, -0.99f)
                curveToRelative(0.46f, -0.39f, 0.96f, -0.78f, 1.49f, -1.17f)
                lineToRelative(-1.55f, -2.97f)
                curveTo(6.15f, 13.3f, 6.0f, 12.64f, 6.0f, 12.0f)
                verticalLineTo(8.0f)
                curveToRelative(0.0f, -1.1f, 0.9f, -2.0f, 2.0f, -2.0f)
                horizontalLineToRelative(3.0f)
                curveToRelative(1.38f, 0.0f, 2.63f, -0.56f, 3.54f, -1.46f)
                lineToRelative(1.41f, 1.41f)
                curveTo(14.68f, 7.21f, 12.93f, 8.0f, 11.0f, 8.0f)
                horizontalLineTo(9.6f)
                lineToRelative(0.0f, 3.5f)
                horizontalLineToRelative(2.8f)
                lineToRelative(1.69f, 1.88f)
                curveToRelative(1.95f, -0.84f, 3.77f, -1.38f, 5.06f, -1.38f)
                curveTo(19.99f, 12.0f, 21.0f, 12.25f, 21.0f, 13.28f)
                close()
                moveTo(12.2f, 14.27f)
                lineToRelative(-0.7f, -0.77f)
                lineTo(9.0f, 13.6f)
                lineToRelative(0.83f, 2.01f)
                curveTo(10.42f, 15.23f, 11.64f, 14.55f, 12.2f, 14.27f)
                close()
            }
        }
        return _kitesurfing!!
    }

private var _kitesurfing: ImageVector? = null
