/*
 * Copyright 2022 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package androidx.compose.material.icons.outlined

import androidx.compose.material.icons.Icons
import androidx.compose.material.icons.materialIcon
import androidx.compose.material.icons.materialPath
import androidx.compose.ui.graphics.vector.ImageVector

public val Icons.Outlined.Hvac: ImageVector
    get() {
        if (_hvac != null) {
            return _hvac!!
        }
        _hvac = materialIcon(name = "Outlined.Hvac") {
            materialPath {
                moveTo(19.0f, 3.0f)
                horizontalLineTo(5.0f)
                curveTo(3.9f, 3.0f, 3.0f, 3.9f, 3.0f, 5.0f)
                verticalLineToRelative(14.0f)
                curveToRelative(0.0f, 1.1f, 0.9f, 2.0f, 2.0f, 2.0f)
                horizontalLineToRelative(14.0f)
                curveToRelative(1.1f, 0.0f, 2.0f, -0.9f, 2.0f, -2.0f)
                verticalLineTo(5.0f)
                curveTo(21.0f, 3.9f, 20.1f, 3.0f, 19.0f, 3.0f)
                close()
                moveTo(19.0f, 19.0f)
                horizontalLineTo(5.0f)
                verticalLineTo(5.0f)
                horizontalLineToRelative(14.0f)
                verticalLineTo(19.0f)
                close()
            }
            materialPath {
                moveTo(12.0f, 18.0f)
                curveToRelative(3.31f, 0.0f, 6.0f, -2.69f, 6.0f, -6.0f)
                reflectiveCurveToRelative(-2.69f, -6.0f, -6.0f, -6.0f)
                reflectiveCurveToRelative(-6.0f, 2.69f, -6.0f, 6.0f)
                reflectiveCurveTo(8.69f, 18.0f, 12.0f, 18.0f)
                close()
                moveTo(15.44f, 10.0f)
                curveToRelative(0.26f, 0.45f, 0.44f, 0.96f, 0.51f, 1.5f)
                horizontalLineToRelative(-7.9f)
                curveToRelative(0.07f, -0.54f, 0.24f, -1.05f, 0.51f, -1.5f)
                horizontalLineTo(15.44f)
                close()
                moveTo(15.95f, 12.5f)
                curveToRelative(-0.07f, 0.54f, -0.24f, 1.05f, -0.51f, 1.5f)
                horizontalLineTo(8.56f)
                curveToRelative(-0.26f, -0.45f, -0.44f, -0.96f, -0.51f, -1.5f)
                horizontalLineTo(15.95f)
                close()
                moveTo(9.38f, 15.0f)
                horizontalLineToRelative(5.24f)
                curveToRelative(-0.7f, 0.61f, -1.61f, 1.0f, -2.62f, 1.0f)
                reflectiveCurveTo(10.09f, 15.61f, 9.38f, 15.0f)
                close()
                moveTo(14.62f, 9.0f)
                horizontalLineTo(9.38f)
                curveToRelative(0.7f, -0.61f, 1.61f, -1.0f, 2.62f, -1.0f)
                reflectiveCurveTo(13.91f, 8.39f, 14.62f, 9.0f)
                close()
            }
        }
        return _hvac!!
    }

private var _hvac: ImageVector? = null
