/*
 * Copyright 2022 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package androidx.compose.material.icons.outlined

import androidx.compose.material.icons.Icons
import androidx.compose.material.icons.materialIcon
import androidx.compose.material.icons.materialPath
import androidx.compose.ui.graphics.vector.ImageVector

public val Icons.Outlined.FiberDvr: ImageVector
    get() {
        if (_fiberDvr != null) {
            return _fiberDvr!!
        }
        _fiberDvr = materialIcon(name = "Outlined.FiberDvr") {
            materialPath {
                moveTo(11.87f, 12.43f)
                lineToRelative(-1.0f, -3.43f)
                horizontalLineToRelative(-1.5f)
                lineToRelative(1.75f, 6.0f)
                horizontalLineToRelative(1.5f)
                lineToRelative(1.75f, -6.0f)
                horizontalLineToRelative(-1.5f)
                close()
                moveTo(21.0f, 11.5f)
                verticalLineToRelative(-1.0f)
                curveToRelative(0.0f, -0.85f, -0.65f, -1.5f, -1.5f, -1.5f)
                lineTo(16.0f, 9.0f)
                verticalLineToRelative(6.0f)
                horizontalLineToRelative(1.5f)
                verticalLineToRelative(-2.0f)
                horizontalLineToRelative(1.15f)
                lineToRelative(0.85f, 2.0f)
                lineTo(21.0f, 15.0f)
                lineToRelative(-0.9f, -2.1f)
                curveToRelative(0.5f, -0.25f, 0.9f, -0.8f, 0.9f, -1.4f)
                close()
                moveTo(19.5f, 11.5f)
                horizontalLineToRelative(-2.0f)
                verticalLineToRelative(-1.0f)
                horizontalLineToRelative(2.0f)
                verticalLineToRelative(1.0f)
                close()
                moveTo(6.5f, 9.0f)
                lineTo(3.0f, 9.0f)
                verticalLineToRelative(6.0f)
                horizontalLineToRelative(3.5f)
                curveToRelative(0.85f, 0.0f, 1.5f, -0.65f, 1.5f, -1.5f)
                verticalLineToRelative(-3.0f)
                curveTo(8.0f, 9.65f, 7.35f, 9.0f, 6.5f, 9.0f)
                close()
                moveTo(6.5f, 13.5f)
                horizontalLineToRelative(-2.0f)
                verticalLineToRelative(-3.0f)
                horizontalLineToRelative(2.0f)
                verticalLineToRelative(3.0f)
                close()
            }
        }
        return _fiberDvr!!
    }

private var _fiberDvr: ImageVector? = null
