/*
 * Copyright 2022 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package androidx.compose.material.icons.outlined

import androidx.compose.material.icons.Icons
import androidx.compose.material.icons.materialIcon
import androidx.compose.material.icons.materialPath
import androidx.compose.ui.graphics.vector.ImageVector

public val Icons.Outlined.ExposurePlus2: ImageVector
    get() {
        if (_exposurePlus2 != null) {
            return _exposurePlus2!!
        }
        _exposurePlus2 = materialIcon(name = "Outlined.ExposurePlus2") {
            materialPath {
                moveTo(16.05f, 16.29f)
                lineToRelative(2.86f, -3.07f)
                curveToRelative(0.38f, -0.39f, 0.72f, -0.79f, 1.04f, -1.18f)
                curveToRelative(0.32f, -0.39f, 0.59f, -0.78f, 0.82f, -1.17f)
                reflectiveCurveToRelative(0.41f, -0.78f, 0.54f, -1.17f)
                curveToRelative(0.13f, -0.39f, 0.19f, -0.79f, 0.19f, -1.18f)
                curveToRelative(0.0f, -0.53f, -0.09f, -1.02f, -0.27f, -1.46f)
                reflectiveCurveToRelative(-0.44f, -0.81f, -0.78f, -1.11f)
                curveToRelative(-0.34f, -0.31f, -0.77f, -0.54f, -1.26f, -0.71f)
                curveToRelative(-0.51f, -0.16f, -1.08f, -0.24f, -1.72f, -0.24f)
                curveToRelative(-0.69f, 0.0f, -1.31f, 0.11f, -1.85f, 0.32f)
                curveToRelative(-0.54f, 0.21f, -1.0f, 0.51f, -1.36f, 0.88f)
                curveToRelative(-0.37f, 0.37f, -0.65f, 0.8f, -0.84f, 1.3f)
                curveToRelative(-0.18f, 0.47f, -0.27f, 0.97f, -0.28f, 1.5f)
                horizontalLineToRelative(2.14f)
                curveToRelative(0.01f, -0.31f, 0.05f, -0.6f, 0.13f, -0.87f)
                curveToRelative(0.09f, -0.29f, 0.23f, -0.54f, 0.4f, -0.75f)
                curveToRelative(0.18f, -0.21f, 0.41f, -0.37f, 0.68f, -0.49f)
                reflectiveCurveToRelative(0.6f, -0.18f, 0.96f, -0.18f)
                curveToRelative(0.31f, 0.0f, 0.58f, 0.05f, 0.81f, 0.15f)
                reflectiveCurveToRelative(0.43f, 0.25f, 0.59f, 0.43f)
                reflectiveCurveToRelative(0.28f, 0.4f, 0.37f, 0.65f)
                curveToRelative(0.08f, 0.25f, 0.13f, 0.52f, 0.13f, 0.81f)
                curveToRelative(0.0f, 0.22f, -0.03f, 0.43f, -0.08f, 0.65f)
                curveToRelative(-0.06f, 0.22f, -0.15f, 0.45f, -0.29f, 0.7f)
                curveToRelative(-0.14f, 0.25f, -0.32f, 0.53f, -0.56f, 0.83f)
                curveToRelative(-0.23f, 0.3f, -0.52f, 0.65f, -0.88f, 1.03f)
                lineToRelative(-4.17f, 4.55f)
                verticalLineTo(18.0f)
                horizontalLineTo(22.0f)
                verticalLineToRelative(-1.71f)
                horizontalLineToRelative(-5.95f)
                close()
                moveTo(8.0f, 7.0f)
                horizontalLineTo(6.0f)
                verticalLineToRelative(4.0f)
                horizontalLineTo(2.0f)
                verticalLineToRelative(2.0f)
                horizontalLineToRelative(4.0f)
                verticalLineToRelative(4.0f)
                horizontalLineToRelative(2.0f)
                verticalLineToRelative(-4.0f)
                horizontalLineToRelative(4.0f)
                verticalLineToRelative(-2.0f)
                horizontalLineTo(8.0f)
                verticalLineTo(7.0f)
                close()
            }
        }
        return _exposurePlus2!!
    }

private var _exposurePlus2: ImageVector? = null
