/*
 * Copyright 2022 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package androidx.compose.material.icons.outlined

import androidx.compose.material.icons.Icons
import androidx.compose.material.icons.materialIcon
import androidx.compose.material.icons.materialPath
import androidx.compose.ui.graphics.vector.ImageVector

public val Icons.Outlined.ExposurePlus1: ImageVector
    get() {
        if (_exposurePlus1 != null) {
            return _exposurePlus1!!
        }
        _exposurePlus1 = materialIcon(name = "Outlined.ExposurePlus1") {
            materialPath {
                moveTo(10.0f, 7.0f)
                lineTo(8.0f, 7.0f)
                verticalLineToRelative(4.0f)
                lineTo(4.0f, 11.0f)
                verticalLineToRelative(2.0f)
                horizontalLineToRelative(4.0f)
                verticalLineToRelative(4.0f)
                horizontalLineToRelative(2.0f)
                verticalLineToRelative(-4.0f)
                horizontalLineToRelative(4.0f)
                verticalLineToRelative(-2.0f)
                horizontalLineToRelative(-4.0f)
                lineTo(10.0f, 7.0f)
                close()
                moveTo(20.0f, 18.0f)
                horizontalLineToRelative(-2.0f)
                lineTo(18.0f, 7.38f)
                lineTo(15.0f, 8.4f)
                lineTo(15.0f, 6.7f)
                lineTo(19.7f, 5.0f)
                horizontalLineToRelative(0.3f)
                verticalLineToRelative(13.0f)
                close()
            }
        }
        return _exposurePlus1!!
    }

private var _exposurePlus1: ImageVector? = null
