/*
 * Copyright 2022 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package androidx.compose.material.icons.outlined

import androidx.compose.material.icons.Icons
import androidx.compose.material.icons.materialIcon
import androidx.compose.material.icons.materialPath
import androidx.compose.ui.graphics.vector.ImageVector

public val Icons.Outlined.ElectricRickshaw: ImageVector
    get() {
        if (_electricRickshaw != null) {
            return _electricRickshaw!!
        }
        _electricRickshaw = materialIcon(name = "Outlined.ElectricRickshaw") {
            materialPath {
                moveTo(21.0f, 11.18f)
                verticalLineTo(9.72f)
                curveToRelative(0.0f, -0.47f, -0.16f, -0.92f, -0.46f, -1.28f)
                lineTo(16.6f, 3.72f)
                curveTo(16.22f, 3.26f, 15.66f, 3.0f, 15.06f, 3.0f)
                horizontalLineTo(3.0f)
                curveTo(1.9f, 3.0f, 1.0f, 3.9f, 1.0f, 5.0f)
                verticalLineToRelative(8.0f)
                curveToRelative(0.0f, 1.1f, 0.9f, 2.0f, 2.0f, 2.0f)
                horizontalLineToRelative(0.18f)
                curveTo(3.6f, 16.16f, 4.7f, 17.0f, 6.0f, 17.0f)
                reflectiveCurveToRelative(2.4f, -0.84f, 2.82f, -2.0f)
                horizontalLineToRelative(8.37f)
                curveToRelative(0.41f, 1.16f, 1.51f, 2.0f, 2.82f, 2.0f)
                curveToRelative(1.66f, 0.0f, 3.0f, -1.34f, 3.0f, -3.0f)
                curveTo(23.0f, 12.7f, 22.16f, 11.6f, 21.0f, 11.18f)
                close()
                moveTo(6.0f, 15.0f)
                curveToRelative(-0.55f, 0.0f, -1.0f, -0.45f, -1.0f, -1.0f)
                reflectiveCurveToRelative(0.45f, -1.0f, 1.0f, -1.0f)
                reflectiveCurveToRelative(1.0f, 0.45f, 1.0f, 1.0f)
                reflectiveCurveTo(6.55f, 15.0f, 6.0f, 15.0f)
                close()
                moveTo(7.0f, 11.17f)
                curveTo(6.69f, 11.06f, 6.35f, 11.0f, 6.0f, 11.0f)
                curveToRelative(-1.3f, 0.0f, -2.42f, 0.84f, -2.83f, 2.0f)
                horizontalLineTo(3.0f)
                verticalLineToRelative(-3.0f)
                horizontalLineToRelative(4.0f)
                verticalLineTo(11.17f)
                close()
                moveTo(7.0f, 8.0f)
                horizontalLineTo(3.0f)
                verticalLineTo(5.0f)
                horizontalLineToRelative(4.0f)
                verticalLineTo(8.0f)
                close()
                moveTo(14.0f, 13.0f)
                horizontalLineTo(9.0f)
                verticalLineToRelative(-3.0f)
                horizontalLineToRelative(3.0f)
                verticalLineTo(8.0f)
                horizontalLineTo(9.0f)
                verticalLineTo(5.0f)
                horizontalLineToRelative(5.0f)
                verticalLineTo(13.0f)
                close()
                moveTo(16.0f, 6.12f)
                lineTo(18.4f, 9.0f)
                horizontalLineTo(16.0f)
                verticalLineTo(6.12f)
                close()
                moveTo(17.17f, 13.0f)
                horizontalLineTo(16.0f)
                verticalLineToRelative(-2.0f)
                horizontalLineToRelative(3.0f)
                verticalLineToRelative(0.17f)
                curveTo(18.15f, 11.47f, 17.47f, 12.15f, 17.17f, 13.0f)
                close()
                moveTo(20.0f, 15.0f)
                curveToRelative(-0.55f, 0.0f, -1.0f, -0.45f, -1.0f, -1.0f)
                reflectiveCurveToRelative(0.45f, -1.0f, 1.0f, -1.0f)
                reflectiveCurveToRelative(1.0f, 0.45f, 1.0f, 1.0f)
                reflectiveCurveTo(20.55f, 15.0f, 20.0f, 15.0f)
                close()
            }
            materialPath {
                moveTo(7.0f, 20.0f)
                lineToRelative(4.0f, 0.0f)
                lineToRelative(0.0f, -2.0f)
                lineToRelative(6.0f, 3.0f)
                lineToRelative(-4.0f, 0.0f)
                lineToRelative(0.0f, 2.0f)
                close()
            }
        }
        return _electricRickshaw!!
    }

private var _electricRickshaw: ImageVector? = null
