/*
 * Copyright 2022 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package androidx.compose.material.icons.outlined

import androidx.compose.material.icons.Icons
import androidx.compose.material.icons.materialIcon
import androidx.compose.material.icons.materialPath
import androidx.compose.ui.graphics.vector.ImageVector

public val Icons.Outlined.DoDisturbAlt: ImageVector
    get() {
        if (_doDisturbAlt != null) {
            return _doDisturbAlt!!
        }
        _doDisturbAlt = materialIcon(name = "Outlined.DoDisturbAlt") {
            materialPath {
                moveTo(12.0f, 2.0f)
                curveTo(6.5f, 2.0f, 2.0f, 6.5f, 2.0f, 12.0f)
                reflectiveCurveToRelative(4.5f, 10.0f, 10.0f, 10.0f)
                reflectiveCurveToRelative(10.0f, -4.5f, 10.0f, -10.0f)
                reflectiveCurveTo(17.5f, 2.0f, 12.0f, 2.0f)
                close()
                moveTo(4.0f, 12.0f)
                curveToRelative(0.0f, -4.4f, 3.6f, -8.0f, 8.0f, -8.0f)
                curveToRelative(1.8f, 0.0f, 3.5f, 0.6f, 4.9f, 1.7f)
                lineTo(5.7f, 16.9f)
                curveTo(4.6f, 15.5f, 4.0f, 13.8f, 4.0f, 12.0f)
                close()
                moveTo(12.0f, 20.0f)
                curveToRelative(-1.8f, 0.0f, -3.5f, -0.6f, -4.9f, -1.7f)
                lineTo(18.3f, 7.1f)
                curveTo(19.4f, 8.5f, 20.0f, 10.2f, 20.0f, 12.0f)
                curveToRelative(0.0f, 4.4f, -3.6f, 8.0f, -8.0f, 8.0f)
                close()
            }
        }
        return _doDisturbAlt!!
    }

private var _doDisturbAlt: ImageVector? = null
