/*
 * Copyright 2022 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package androidx.compose.material.icons.outlined

import androidx.compose.material.icons.Icons
import androidx.compose.material.icons.materialIcon
import androidx.compose.material.icons.materialPath
import androidx.compose.ui.graphics.vector.ImageVector

public val Icons.Outlined.CurrencyRupee: ImageVector
    get() {
        if (_currencyRupee != null) {
            return _currencyRupee!!
        }
        _currencyRupee = materialIcon(name = "Outlined.CurrencyRupee") {
            materialPath {
                moveTo(13.66f, 7.0f)
                curveTo(13.1f, 5.82f, 11.9f, 5.0f, 10.5f, 5.0f)
                lineTo(6.0f, 5.0f)
                verticalLineTo(3.0f)
                horizontalLineToRelative(12.0f)
                verticalLineToRelative(2.0f)
                lineToRelative(-3.26f, 0.0f)
                curveToRelative(0.48f, 0.58f, 0.84f, 1.26f, 1.05f, 2.0f)
                lineTo(18.0f, 7.0f)
                verticalLineToRelative(2.0f)
                lineToRelative(-2.02f, 0.0f)
                curveToRelative(-0.25f, 2.8f, -2.61f, 5.0f, -5.48f, 5.0f)
                horizontalLineTo(9.77f)
                lineToRelative(6.73f, 7.0f)
                horizontalLineToRelative(-2.77f)
                lineTo(7.0f, 14.0f)
                verticalLineToRelative(-2.0f)
                horizontalLineToRelative(3.5f)
                curveToRelative(1.76f, 0.0f, 3.22f, -1.3f, 3.46f, -3.0f)
                lineTo(6.0f, 9.0f)
                verticalLineTo(7.0f)
                lineTo(13.66f, 7.0f)
                close()
            }
        }
        return _currencyRupee!!
    }

private var _currencyRupee: ImageVector? = null
