/*
 * Copyright 2022 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package androidx.compose.material.icons.outlined

import androidx.compose.material.icons.Icons
import androidx.compose.material.icons.materialIcon
import androidx.compose.material.icons.materialPath
import androidx.compose.ui.graphics.vector.ImageVector

public val Icons.Outlined.ChangeCircle: ImageVector
    get() {
        if (_changeCircle != null) {
            return _changeCircle!!
        }
        _changeCircle = materialIcon(name = "Outlined.ChangeCircle") {
            materialPath {
                moveTo(12.0f, 2.0f)
                curveTo(6.48f, 2.0f, 2.0f, 6.48f, 2.0f, 12.0f)
                reflectiveCurveToRelative(4.48f, 10.0f, 10.0f, 10.0f)
                reflectiveCurveToRelative(10.0f, -4.48f, 10.0f, -10.0f)
                reflectiveCurveTo(17.52f, 2.0f, 12.0f, 2.0f)
                close()
                moveTo(12.0f, 20.0f)
                curveToRelative(-4.41f, 0.0f, -8.0f, -3.59f, -8.0f, -8.0f)
                reflectiveCurveToRelative(3.59f, -8.0f, 8.0f, -8.0f)
                reflectiveCurveToRelative(8.0f, 3.59f, 8.0f, 8.0f)
                reflectiveCurveTo(16.41f, 20.0f, 12.0f, 20.0f)
                close()
                moveTo(16.17f, 14.76f)
                lineToRelative(-1.1f, -1.1f)
                curveToRelative(0.71f, -1.33f, 0.53f, -3.01f, -0.59f, -4.13f)
                curveTo(13.79f, 8.84f, 12.9f, 8.5f, 12.0f, 8.5f)
                curveToRelative(-0.03f, 0.0f, -0.06f, 0.01f, -0.09f, 0.01f)
                lineTo(13.0f, 9.6f)
                lineToRelative(-1.06f, 1.06f)
                lineTo(9.11f, 7.83f)
                lineTo(11.94f, 5.0f)
                lineTo(13.0f, 6.06f)
                lineToRelative(-0.96f, 0.96f)
                curveToRelative(1.27f, 0.01f, 2.53f, 0.48f, 3.5f, 1.44f)
                curveTo(17.24f, 10.17f, 17.45f, 12.82f, 16.17f, 14.76f)
                close()
                moveTo(14.89f, 16.17f)
                lineTo(12.06f, 19.0f)
                lineTo(11.0f, 17.94f)
                lineToRelative(0.95f, -0.95f)
                curveToRelative(-1.26f, -0.01f, -2.52f, -0.5f, -3.48f, -1.46f)
                curveToRelative(-1.71f, -1.71f, -1.92f, -4.35f, -0.64f, -6.29f)
                lineToRelative(1.1f, 1.1f)
                curveToRelative(-0.71f, 1.33f, -0.53f, 3.01f, 0.59f, 4.13f)
                curveToRelative(0.7f, 0.7f, 1.63f, 1.04f, 2.56f, 1.01f)
                lineTo(11.0f, 14.4f)
                lineToRelative(1.06f, -1.06f)
                lineTo(14.89f, 16.17f)
                close()
            }
        }
        return _changeCircle!!
    }

private var _changeCircle: ImageVector? = null
