/*
 * Copyright 2022 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package androidx.compose.material.icons.outlined

import androidx.compose.material.icons.Icons
import androidx.compose.material.icons.materialIcon
import androidx.compose.material.icons.materialPath
import androidx.compose.ui.graphics.vector.ImageVector

public val Icons.Outlined.CarRental: ImageVector
    get() {
        if (_carRental != null) {
            return _carRental!!
        }
        _carRental = materialIcon(name = "Outlined.CarRental") {
            materialPath {
                moveTo(9.0f, 16.5f)
                moveToRelative(-1.0f, 0.0f)
                arcToRelative(1.0f, 1.0f, 0.0f, true, true, 2.0f, 0.0f)
                arcToRelative(1.0f, 1.0f, 0.0f, true, true, -2.0f, 0.0f)
            }
            materialPath {
                moveTo(15.0f, 16.5f)
                moveToRelative(-1.0f, 0.0f)
                arcToRelative(1.0f, 1.0f, 0.0f, true, true, 2.0f, 0.0f)
                arcToRelative(1.0f, 1.0f, 0.0f, true, true, -2.0f, 0.0f)
            }
            materialPath {
                moveTo(17.25f, 9.6f)
                curveToRelative(-0.02f, -0.02f, -0.03f, -0.04f, -0.05f, -0.07f)
                curveTo(16.82f, 9.01f, 16.28f, 9.0f, 16.28f, 9.0f)
                horizontalLineTo(7.72f)
                curveToRelative(0.0f, 0.0f, -0.54f, 0.01f, -0.92f, 0.54f)
                curveTo(6.78f, 9.56f, 6.77f, 9.58f, 6.75f, 9.6f)
                curveTo(6.68f, 9.71f, 6.61f, 9.84f, 6.56f, 10.0f)
                curveTo(6.34f, 10.66f, 5.82f, 12.22f, 5.0f, 14.69f)
                verticalLineToRelative(6.5f)
                curveTo(5.0f, 21.64f, 5.35f, 22.0f, 5.78f, 22.0f)
                horizontalLineToRelative(0.44f)
                curveTo(6.65f, 22.0f, 7.0f, 21.64f, 7.0f, 21.19f)
                verticalLineTo(20.0f)
                horizontalLineToRelative(10.0f)
                verticalLineToRelative(1.19f)
                curveToRelative(0.0f, 0.45f, 0.34f, 0.81f, 0.78f, 0.81f)
                horizontalLineToRelative(0.44f)
                curveToRelative(0.43f, 0.0f, 0.78f, -0.36f, 0.78f, -0.81f)
                verticalLineToRelative(-6.5f)
                curveToRelative(-0.82f, -2.46f, -1.34f, -4.03f, -1.56f, -4.69f)
                curveTo(17.39f, 9.84f, 17.32f, 9.71f, 17.25f, 9.6f)
                close()
                moveTo(8.33f, 11.0f)
                horizontalLineToRelative(7.34f)
                lineToRelative(0.23f, 0.69f)
                lineTo(16.33f, 13.0f)
                horizontalLineTo(7.67f)
                lineTo(8.33f, 11.0f)
                close()
                moveTo(17.0f, 18.0f)
                horizontalLineTo(7.0f)
                verticalLineToRelative(-2.99f)
                verticalLineTo(15.0f)
                horizontalLineToRelative(10.0f)
                verticalLineToRelative(0.01f)
                verticalLineTo(18.0f)
                close()
            }
            materialPath {
                moveTo(10.83f, 3.0f)
                curveTo(10.41f, 1.83f, 9.3f, 1.0f, 8.0f, 1.0f)
                curveTo(6.34f, 1.0f, 5.0f, 2.34f, 5.0f, 4.0f)
                curveToRelative(0.0f, 1.65f, 1.34f, 3.0f, 3.0f, 3.0f)
                curveToRelative(1.3f, 0.0f, 2.41f, -0.84f, 2.83f, -2.0f)
                horizontalLineTo(16.0f)
                verticalLineToRelative(2.0f)
                horizontalLineToRelative(2.0f)
                verticalLineTo(5.0f)
                horizontalLineToRelative(1.0f)
                verticalLineTo(3.0f)
                horizontalLineTo(10.83f)
                close()
                moveTo(8.0f, 5.0f)
                curveTo(7.45f, 5.0f, 7.0f, 4.55f, 7.0f, 4.0f)
                reflectiveCurveToRelative(0.45f, -1.0f, 1.0f, -1.0f)
                reflectiveCurveToRelative(1.0f, 0.45f, 1.0f, 1.0f)
                reflectiveCurveTo(8.55f, 5.0f, 8.0f, 5.0f)
                close()
            }
        }
        return _carRental!!
    }

private var _carRental: ImageVector? = null
