/*
 * Copyright 2022 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package androidx.compose.material.icons.outlined

import androidx.compose.material.icons.Icons
import androidx.compose.material.icons.materialIcon
import androidx.compose.material.icons.materialPath
import androidx.compose.ui.graphics.vector.ImageVector

public val Icons.Outlined.BedroomBaby: ImageVector
    get() {
        if (_bedroomBaby != null) {
            return _bedroomBaby!!
        }
        _bedroomBaby = materialIcon(name = "Outlined.BedroomBaby") {
            materialPath {
                moveTo(17.94f, 14.04f)
                curveToRelative(-0.34f, 0.34f, -0.71f, 0.64f, -1.1f, 0.92f)
                lineTo(16.0f, 13.5f)
                verticalLineTo(11.0f)
                horizontalLineToRelative(1.0f)
                verticalLineToRelative(-1.0f)
                horizontalLineToRelative(-5.62f)
                lineTo(9.65f, 7.0f)
                horizontalLineTo(6.0f)
                lineToRelative(1.0f, 0.76f)
                lineTo(5.5f, 9.5f)
                lineToRelative(0.95f, 1.0f)
                lineTo(8.0f, 9.51f)
                verticalLineToRelative(3.99f)
                lineToRelative(-0.84f, 1.46f)
                curveToRelative(-0.39f, -0.27f, -0.76f, -0.58f, -1.1f, -0.92f)
                lineTo(5.0f, 15.1f)
                curveToRelative(1.87f, 1.87f, 4.36f, 2.9f, 7.0f, 2.9f)
                reflectiveCurveToRelative(5.13f, -1.03f, 7.0f, -2.9f)
                lineTo(17.94f, 14.04f)
                close()
                moveTo(8.45f, 15.71f)
                lineToRelative(0.03f, -0.06f)
                lineToRelative(0.81f, -1.41f)
                curveToRelative(1.74f, 0.65f, 3.66f, 0.65f, 5.4f, 0.0f)
                lineToRelative(0.81f, 1.41f)
                lineToRelative(0.03f, 0.06f)
                curveToRelative(-1.1f, 0.51f, -2.3f, 0.79f, -3.55f, 0.79f)
                reflectiveCurveTo(9.55f, 16.23f, 8.45f, 15.71f)
                close()
                moveTo(20.0f, 4.0f)
                verticalLineToRelative(16.0f)
                horizontalLineTo(4.0f)
                verticalLineTo(4.0f)
                horizontalLineTo(20.0f)
                moveTo(20.0f, 2.0f)
                horizontalLineTo(4.0f)
                curveTo(2.9f, 2.0f, 2.0f, 2.9f, 2.0f, 4.0f)
                verticalLineToRelative(16.0f)
                curveToRelative(0.0f, 1.1f, 0.9f, 2.0f, 2.0f, 2.0f)
                horizontalLineToRelative(16.0f)
                curveToRelative(1.1f, 0.0f, 2.0f, -0.9f, 2.0f, -2.0f)
                verticalLineTo(4.0f)
                curveTo(22.0f, 2.9f, 21.1f, 2.0f, 20.0f, 2.0f)
                close()
            }
        }
        return _bedroomBaby!!
    }

private var _bedroomBaby: ImageVector? = null
