/*
 * Copyright 2022 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package androidx.compose.material.icons.filled

import androidx.compose.material.icons.Icons
import androidx.compose.material.icons.materialIcon
import androidx.compose.material.icons.materialPath
import androidx.compose.ui.graphics.vector.ImageVector

public val Icons.Filled._6kPlus: ImageVector
    get() {
        if (__6kPlus != null) {
            return __6kPlus!!
        }
        __6kPlus = materialIcon(name = "Filled._6kPlus") {
            materialPath {
                moveTo(6.5f, 12.5f)
                lineTo(8.0f, 12.5f)
                lineTo(8.0f, 14.0f)
                lineTo(6.5f, 14.0f)
                close()
                moveTo(19.0f, 3.0f)
                lineTo(5.0f, 3.0f)
                curveToRelative(-1.1f, 0.0f, -2.0f, 0.9f, -2.0f, 2.0f)
                verticalLineToRelative(14.0f)
                curveToRelative(0.0f, 1.1f, 0.9f, 2.0f, 2.0f, 2.0f)
                horizontalLineToRelative(14.0f)
                curveToRelative(1.1f, 0.0f, 2.0f, -0.9f, 2.0f, -2.0f)
                lineTo(21.0f, 5.0f)
                curveToRelative(0.0f, -1.1f, -0.9f, -2.0f, -2.0f, -2.0f)
                close()
                moveTo(9.5f, 10.5f)
                horizontalLineToRelative(-3.0f)
                verticalLineToRelative(1.0f)
                horizontalLineToRelative(2.0f)
                curveToRelative(0.55f, 0.0f, 1.0f, 0.45f, 1.0f, 1.0f)
                lineTo(9.5f, 14.0f)
                curveToRelative(0.0f, 0.55f, -0.45f, 1.0f, -1.0f, 1.0f)
                lineTo(6.0f, 15.0f)
                curveToRelative(-0.55f, 0.0f, -1.0f, -0.45f, -1.0f, -1.0f)
                verticalLineToRelative(-4.0f)
                curveToRelative(0.0f, -0.55f, 0.45f, -1.0f, 1.0f, -1.0f)
                horizontalLineToRelative(3.5f)
                verticalLineToRelative(1.5f)
                close()
                moveTo(16.0f, 15.0f)
                horizontalLineToRelative(-1.75f)
                lineToRelative(-1.75f, -2.25f)
                lineTo(12.5f, 15.0f)
                lineTo(11.0f, 15.0f)
                lineTo(11.0f, 9.0f)
                horizontalLineToRelative(1.5f)
                verticalLineToRelative(2.25f)
                lineTo(14.25f, 9.0f)
                lineTo(16.0f, 9.0f)
                lineToRelative(-2.25f, 3.0f)
                lineTo(16.0f, 15.0f)
                close()
                moveTo(20.0f, 12.5f)
                horizontalLineToRelative(-1.5f)
                lineTo(18.5f, 14.0f)
                horizontalLineToRelative(-1.0f)
                verticalLineToRelative(-1.5f)
                lineTo(16.0f, 12.5f)
                verticalLineToRelative(-1.0f)
                horizontalLineToRelative(1.5f)
                lineTo(17.5f, 10.0f)
                horizontalLineToRelative(1.0f)
                verticalLineToRelative(1.5f)
                lineTo(20.0f, 11.5f)
                verticalLineToRelative(1.0f)
                close()
            }
        }
        return __6kPlus!!
    }

private var __6kPlus: ImageVector? = null
