/*
 * Copyright 2022 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package androidx.compose.material.icons.filled

import androidx.compose.material.icons.Icons
import androidx.compose.material.icons.materialIcon
import androidx.compose.material.icons.materialPath
import androidx.compose.ui.graphics.vector.ImageVector

public val Icons.Filled._1k: ImageVector
    get() {
        if (__1k != null) {
            return __1k!!
        }
        __1k = materialIcon(name = "Filled._1k") {
            materialPath {
                moveTo(19.0f, 3.0f)
                lineTo(5.0f, 3.0f)
                curveToRelative(-1.1f, 0.0f, -2.0f, 0.9f, -2.0f, 2.0f)
                verticalLineToRelative(14.0f)
                curveToRelative(0.0f, 1.1f, 0.9f, 2.0f, 2.0f, 2.0f)
                horizontalLineToRelative(14.0f)
                curveToRelative(1.1f, 0.0f, 2.0f, -0.9f, 2.0f, -2.0f)
                lineTo(21.0f, 5.0f)
                curveToRelative(0.0f, -1.1f, -0.9f, -2.0f, -2.0f, -2.0f)
                close()
                moveTo(10.5f, 15.0f)
                lineTo(9.0f, 15.0f)
                verticalLineToRelative(-4.5f)
                lineTo(7.5f, 10.5f)
                lineTo(7.5f, 9.0f)
                horizontalLineToRelative(3.0f)
                verticalLineToRelative(6.0f)
                close()
                moveTo(17.5f, 15.0f)
                horizontalLineToRelative(-1.75f)
                lineTo(14.0f, 12.75f)
                lineTo(14.0f, 15.0f)
                horizontalLineToRelative(-1.5f)
                lineTo(12.5f, 9.0f)
                lineTo(14.0f, 9.0f)
                verticalLineToRelative(2.25f)
                lineTo(15.75f, 9.0f)
                horizontalLineToRelative(1.75f)
                lineToRelative(-2.25f, 3.0f)
                lineToRelative(2.25f, 3.0f)
                close()
            }
        }
        return __1k!!
    }

private var __1k: ImageVector? = null
