/*
 * Copyright 2022 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package androidx.compose.material.icons.filled

import androidx.compose.material.icons.Icons
import androidx.compose.material.icons.materialIcon
import androidx.compose.material.icons.materialPath
import androidx.compose.ui.graphics.vector.ImageVector

public val Icons.Filled.TurnSlightLeft: ImageVector
    get() {
        if (_turnSlightLeft != null) {
            return _turnSlightLeft!!
        }
        _turnSlightLeft = materialIcon(name = "Filled.TurnSlightLeft") {
            materialPath {
                moveTo(11.66f, 6.0f)
                verticalLineTo(4.0f)
                horizontalLineTo(6.0f)
                verticalLineToRelative(5.66f)
                horizontalLineToRelative(2.0f)
                verticalLineTo(7.41f)
                lineToRelative(5.0f, 5.0f)
                verticalLineTo(20.0f)
                horizontalLineToRelative(2.0f)
                verticalLineToRelative(-7.58f)
                curveToRelative(0.0f, -0.53f, -0.21f, -1.04f, -0.59f, -1.41f)
                lineToRelative(-5.0f, -5.0f)
                horizontalLineTo(11.66f)
                close()
            }
        }
        return _turnSlightLeft!!
    }

private var _turnSlightLeft: ImageVector? = null
