/*
 * Copyright 2022 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package androidx.compose.material.icons.filled

import androidx.compose.material.icons.Icons
import androidx.compose.material.icons.materialIcon
import androidx.compose.material.icons.materialPath
import androidx.compose.ui.graphics.vector.ImageVector

public val Icons.Filled.SportsCricket: ImageVector
    get() {
        if (_sportsCricket != null) {
            return _sportsCricket!!
        }
        _sportsCricket = materialIcon(name = "Filled.SportsCricket") {
            materialPath {
                moveTo(15.05f, 12.81f)
                lineTo(6.56f, 4.32f)
                curveToRelative(-0.39f, -0.39f, -1.02f, -0.39f, -1.41f, 0.0f)
                lineTo(2.32f, 7.15f)
                curveToRelative(-0.39f, 0.39f, -0.39f, 1.02f, 0.0f, 1.41f)
                lineToRelative(8.49f, 8.49f)
                curveToRelative(0.39f, 0.39f, 1.02f, 0.39f, 1.41f, 0.0f)
                lineToRelative(2.83f, -2.83f)
                curveTo(15.44f, 13.83f, 15.44f, 13.2f, 15.05f, 12.81f)
                close()
            }
            materialPath {
                moveTo(14.3412f, 17.7562f)
                lineToRelative(1.4142f, -1.4142f)
                lineToRelative(4.2426f, 4.2426f)
                lineToRelative(-1.4142f, 1.4142f)
                close()
            }
            materialPath {
                moveTo(18.5f, 5.5f)
                moveToRelative(-3.5f, 0.0f)
                arcToRelative(3.5f, 3.5f, 0.0f, true, true, 7.0f, 0.0f)
                arcToRelative(3.5f, 3.5f, 0.0f, true, true, -7.0f, 0.0f)
            }
        }
        return _sportsCricket!!
    }

private var _sportsCricket: ImageVector? = null
