/*
 * Copyright 2022 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package androidx.compose.material.icons.filled

import androidx.compose.material.icons.Icons
import androidx.compose.material.icons.materialIcon
import androidx.compose.material.icons.materialPath
import androidx.compose.ui.graphics.vector.ImageVector

public val Icons.Filled.SportsBasketball: ImageVector
    get() {
        if (_sportsBasketball != null) {
            return _sportsBasketball!!
        }
        _sportsBasketball = materialIcon(name = "Filled.SportsBasketball") {
            materialPath {
                moveTo(17.09f, 11.0f)
                horizontalLineToRelative(4.86f)
                curveToRelative(-0.16f, -1.61f, -0.71f, -3.11f, -1.54f, -4.4f)
                curveTo(18.68f, 7.43f, 17.42f, 9.05f, 17.09f, 11.0f)
                close()
            }
            materialPath {
                moveTo(6.91f, 11.0f)
                curveTo(6.58f, 9.05f, 5.32f, 7.43f, 3.59f, 6.6f)
                curveTo(2.76f, 7.89f, 2.21f, 9.39f, 2.05f, 11.0f)
                horizontalLineTo(6.91f)
                close()
            }
            materialPath {
                moveTo(15.07f, 11.0f)
                curveToRelative(0.32f, -2.59f, 1.88f, -4.79f, 4.06f, -6.0f)
                curveToRelative(-1.6f, -1.63f, -3.74f, -2.71f, -6.13f, -2.95f)
                verticalLineTo(11.0f)
                horizontalLineTo(15.07f)
                close()
            }
            materialPath {
                moveTo(8.93f, 11.0f)
                horizontalLineTo(11.0f)
                verticalLineTo(2.05f)
                curveTo(8.61f, 2.29f, 6.46f, 3.37f, 4.87f, 5.0f)
                curveTo(7.05f, 6.21f, 8.61f, 8.41f, 8.93f, 11.0f)
                close()
            }
            materialPath {
                moveTo(15.07f, 13.0f)
                horizontalLineTo(13.0f)
                verticalLineToRelative(8.95f)
                curveToRelative(2.39f, -0.24f, 4.54f, -1.32f, 6.13f, -2.95f)
                curveTo(16.95f, 17.79f, 15.39f, 15.59f, 15.07f, 13.0f)
                close()
            }
            materialPath {
                moveTo(3.59f, 17.4f)
                curveToRelative(1.72f, -0.83f, 2.99f, -2.46f, 3.32f, -4.4f)
                horizontalLineTo(2.05f)
                curveTo(2.21f, 14.61f, 2.76f, 16.11f, 3.59f, 17.4f)
                close()
            }
            materialPath {
                moveTo(17.09f, 13.0f)
                curveToRelative(0.33f, 1.95f, 1.59f, 3.57f, 3.32f, 4.4f)
                curveToRelative(0.83f, -1.29f, 1.38f, -2.79f, 1.54f, -4.4f)
                horizontalLineTo(17.09f)
                close()
            }
            materialPath {
                moveTo(8.93f, 13.0f)
                curveToRelative(-0.32f, 2.59f, -1.88f, 4.79f, -4.06f, 6.0f)
                curveToRelative(1.6f, 1.63f, 3.74f, 2.71f, 6.13f, 2.95f)
                verticalLineTo(13.0f)
                horizontalLineTo(8.93f)
                close()
            }
        }
        return _sportsBasketball!!
    }

private var _sportsBasketball: ImageVector? = null
