/*
 * Copyright 2022 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package androidx.compose.material.icons.filled

import androidx.compose.material.icons.Icons
import androidx.compose.material.icons.materialIcon
import androidx.compose.material.icons.materialPath
import androidx.compose.ui.graphics.vector.ImageVector

public val Icons.Filled.Pinch: ImageVector
    get() {
        if (_pinch != null) {
            return _pinch!!
        }
        _pinch = materialIcon(name = "Filled.Pinch") {
            materialPath {
                moveTo(6.0f, 2.5f)
                verticalLineTo(1.0f)
                horizontalLineToRelative(5.0f)
                verticalLineToRelative(5.0f)
                horizontalLineTo(9.5f)
                verticalLineTo(3.56f)
                lineTo(3.56f, 9.5f)
                horizontalLineTo(6.0f)
                verticalLineTo(11.0f)
                horizontalLineTo(1.0f)
                verticalLineTo(6.0f)
                horizontalLineToRelative(1.5f)
                verticalLineToRelative(2.44f)
                lineTo(8.44f, 2.5f)
                horizontalLineTo(6.0f)
                close()
                moveTo(22.98f, 16.82f)
                lineToRelative(-0.63f, 4.46f)
                curveTo(22.21f, 22.27f, 21.36f, 23.0f, 20.37f, 23.0f)
                horizontalLineToRelative(-6.16f)
                curveToRelative(-0.53f, 0.0f, -1.29f, -0.21f, -1.66f, -0.59f)
                lineTo(8.0f, 17.62f)
                lineToRelative(0.83f, -0.84f)
                curveToRelative(0.24f, -0.24f, 0.58f, -0.35f, 0.92f, -0.28f)
                lineTo(13.0f, 17.24f)
                verticalLineTo(6.5f)
                curveTo(13.0f, 5.67f, 13.67f, 5.0f, 14.5f, 5.0f)
                reflectiveCurveTo(16.0f, 5.67f, 16.0f, 6.5f)
                verticalLineToRelative(6.0f)
                horizontalLineToRelative(0.91f)
                curveToRelative(0.31f, 0.0f, 0.62f, 0.07f, 0.89f, 0.21f)
                lineToRelative(4.09f, 2.04f)
                curveTo(22.66f, 15.14f, 23.1f, 15.97f, 22.98f, 16.82f)
                close()
            }
        }
        return _pinch!!
    }

private var _pinch: ImageVector? = null
