/*
 * Copyright 2022 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package androidx.compose.material.icons.filled

import androidx.compose.material.icons.Icons
import androidx.compose.material.icons.materialIcon
import androidx.compose.material.icons.materialPath
import androidx.compose.ui.graphics.vector.ImageVector

public val Icons.Filled.OutdoorGrill: ImageVector
    get() {
        if (_outdoorGrill != null) {
            return _outdoorGrill!!
        }
        _outdoorGrill = materialIcon(name = "Filled.OutdoorGrill") {
            materialPath {
                moveTo(17.0f, 22.0f)
                curveToRelative(1.66f, 0.0f, 3.0f, -1.34f, 3.0f, -3.0f)
                reflectiveCurveToRelative(-1.34f, -3.0f, -3.0f, -3.0f)
                curveToRelative(-1.3f, 0.0f, -2.4f, 0.84f, -2.82f, 2.0f)
                horizontalLineTo(9.14f)
                lineToRelative(1.99f, -3.06f)
                curveTo(11.42f, 14.98f, 11.71f, 15.0f, 12.0f, 15.0f)
                reflectiveCurveToRelative(0.58f, -0.02f, 0.87f, -0.06f)
                lineToRelative(1.02f, 1.57f)
                curveToRelative(0.42f, -0.53f, 0.96f, -0.95f, 1.6f, -1.21f)
                lineToRelative(-0.6f, -0.93f)
                curveTo(17.31f, 13.27f, 19.0f, 10.84f, 19.0f, 8.0f)
                horizontalLineTo(5.0f)
                curveToRelative(0.0f, 2.84f, 1.69f, 5.27f, 4.12f, 6.37f)
                lineToRelative(-3.95f, 6.08f)
                curveToRelative(-0.3f, 0.46f, -0.17f, 1.08f, 0.29f, 1.38f)
                horizontalLineToRelative(0.0f)
                curveToRelative(0.46f, 0.3f, 1.08f, 0.17f, 1.38f, -0.29f)
                lineToRelative(1.0f, -1.55f)
                horizontalLineToRelative(6.34f)
                curveTo(14.6f, 21.16f, 15.7f, 22.0f, 17.0f, 22.0f)
                close()
                moveTo(17.0f, 18.0f)
                curveToRelative(0.55f, 0.0f, 1.0f, 0.45f, 1.0f, 1.0f)
                curveToRelative(0.0f, 0.55f, -0.45f, 1.0f, -1.0f, 1.0f)
                reflectiveCurveToRelative(-1.0f, -0.45f, -1.0f, -1.0f)
                curveTo(16.0f, 18.45f, 16.45f, 18.0f, 17.0f, 18.0f)
                close()
            }
            materialPath {
                moveTo(9.41f, 7.0f)
                horizontalLineToRelative(1.0f)
                curveToRelative(0.15f, -1.15f, 0.23f, -1.64f, -0.89f, -2.96f)
                curveTo(9.1f, 3.54f, 8.84f, 3.27f, 9.06f, 2.0f)
                horizontalLineTo(8.07f)
                curveTo(7.86f, 3.11f, 8.1f, 4.05f, 8.96f, 4.96f)
                curveTo(9.18f, 5.2f, 9.75f, 5.63f, 9.41f, 7.0f)
                close()
            }
            materialPath {
                moveTo(11.89f, 7.0f)
                horizontalLineToRelative(1.0f)
                curveToRelative(0.15f, -1.15f, 0.23f, -1.64f, -0.89f, -2.96f)
                curveToRelative(-0.42f, -0.5f, -0.68f, -0.78f, -0.46f, -2.04f)
                horizontalLineToRelative(-0.99f)
                curveToRelative(-0.21f, 1.11f, 0.03f, 2.05f, 0.89f, 2.96f)
                curveTo(11.67f, 5.2f, 12.24f, 5.63f, 11.89f, 7.0f)
                close()
            }
            materialPath {
                moveTo(14.41f, 7.0f)
                horizontalLineToRelative(1.0f)
                curveToRelative(0.15f, -1.15f, 0.23f, -1.64f, -0.89f, -2.96f)
                curveTo(14.1f, 3.54f, 13.84f, 3.27f, 14.06f, 2.0f)
                horizontalLineToRelative(-0.99f)
                curveToRelative(-0.21f, 1.11f, 0.03f, 2.05f, 0.89f, 2.96f)
                curveTo(14.18f, 5.2f, 14.75f, 5.63f, 14.41f, 7.0f)
                close()
            }
        }
        return _outdoorGrill!!
    }

private var _outdoorGrill: ImageVector? = null
