/*
 * Copyright 2022 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package androidx.compose.material.icons.filled

import androidx.compose.material.icons.Icons
import androidx.compose.material.icons.materialIcon
import androidx.compose.material.icons.materialPath
import androidx.compose.ui.graphics.vector.ImageVector

public val Icons.Filled.NetworkWifi1Bar: ImageVector
    get() {
        if (_networkWifi1Bar != null) {
            return _networkWifi1Bar!!
        }
        _networkWifi1Bar = materialIcon(name = "Filled.NetworkWifi1Bar") {
            materialPath {
                moveTo(12.0f, 4.0f)
                curveTo(7.31f, 4.0f, 3.07f, 5.9f, 0.0f, 8.98f)
                lineTo(12.0f, 21.0f)
                lineTo(24.0f, 8.98f)
                curveTo(20.93f, 5.9f, 16.69f, 4.0f, 12.0f, 4.0f)
                close()
                moveTo(15.32f, 14.84f)
                curveTo(14.34f, 14.3f, 13.2f, 14.0f, 12.0f, 14.0f)
                curveToRelative(-1.2f, 0.0f, -2.34f, 0.3f, -3.32f, 0.84f)
                lineTo(2.92f, 9.07f)
                curveTo(5.51f, 7.08f, 8.67f, 6.0f, 12.0f, 6.0f)
                reflectiveCurveToRelative(6.49f, 1.08f, 9.08f, 3.07f)
                lineTo(15.32f, 14.84f)
                close()
            }
        }
        return _networkWifi1Bar!!
    }

private var _networkWifi1Bar: ImageVector? = null
