/*
 * Copyright 2022 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package androidx.compose.material.icons.filled

import androidx.compose.material.icons.Icons
import androidx.compose.material.icons.materialIcon
import androidx.compose.material.icons.materialPath
import androidx.compose.ui.graphics.vector.ImageVector

public val Icons.Filled.ModeFanOff: ImageVector
    get() {
        if (_modeFanOff != null) {
            return _modeFanOff!!
        }
        _modeFanOff = materialIcon(name = "Filled.ModeFanOff") {
            materialPath {
                moveTo(16.34f, 8.36f)
                lineToRelative(-2.29f, 0.82f)
                curveToRelative(-0.18f, -0.13f, -0.38f, -0.25f, -0.58f, -0.34f)
                curveToRelative(0.17f, -0.83f, 0.63f, -1.58f, 1.36f, -2.06f)
                curveTo(16.85f, 5.44f, 16.18f, 2.0f, 13.39f, 2.0f)
                curveToRelative(-3.08f, 0.0f, -4.9f, 1.47f, -5.3f, 3.26f)
                lineTo(18.73f, 15.9f)
                curveToRelative(1.5f, 0.39f, 3.27f, -0.51f, 3.27f, -2.51f)
                curveTo(22.0f, 9.0f, 18.99f, 7.16f, 16.34f, 8.36f)
                close()
            }
            materialPath {
                moveTo(2.81f, 2.81f)
                lineTo(1.39f, 4.22f)
                lineTo(5.27f, 8.1f)
                curveTo(3.77f, 7.7f, 2.0f, 8.61f, 2.0f, 10.61f)
                curveToRelative(0.0f, 4.4f, 3.01f, 6.24f, 5.66f, 5.03f)
                lineToRelative(2.29f, -0.82f)
                curveToRelative(0.18f, 0.13f, 0.38f, 0.25f, 0.58f, 0.34f)
                curveToRelative(-0.17f, 0.83f, -0.63f, 1.58f, -1.36f, 2.06f)
                curveTo(7.15f, 18.56f, 7.82f, 22.0f, 10.61f, 22.0f)
                curveToRelative(3.08f, 0.0f, 4.9f, -1.47f, 5.3f, -3.26f)
                lineToRelative(3.87f, 3.87f)
                lineToRelative(1.41f, -1.41f)
                lineTo(2.81f, 2.81f)
                close()
            }
        }
        return _modeFanOff!!
    }

private var _modeFanOff: ImageVector? = null
