/*
 * Copyright 2022 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package androidx.compose.material.icons.filled

import androidx.compose.material.icons.Icons
import androidx.compose.material.icons.materialIcon
import androidx.compose.material.icons.materialPath
import androidx.compose.ui.graphics.vector.ImageVector

public val Icons.Filled.HeartBroken: ImageVector
    get() {
        if (_heartBroken != null) {
            return _heartBroken!!
        }
        _heartBroken = materialIcon(name = "Filled.HeartBroken") {
            materialPath {
                moveTo(16.5f, 3.0f)
                curveToRelative(-0.96f, 0.0f, -1.9f, 0.25f, -2.73f, 0.69f)
                lineTo(12.0f, 9.0f)
                horizontalLineToRelative(3.0f)
                lineToRelative(-3.0f, 10.0f)
                lineToRelative(1.0f, -9.0f)
                horizontalLineToRelative(-3.0f)
                lineToRelative(1.54f, -5.39f)
                curveTo(10.47f, 3.61f, 9.01f, 3.0f, 7.5f, 3.0f)
                curveTo(4.42f, 3.0f, 2.0f, 5.42f, 2.0f, 8.5f)
                curveToRelative(0.0f, 4.13f, 4.16f, 7.18f, 10.0f, 12.5f)
                curveToRelative(5.47f, -4.94f, 10.0f, -8.26f, 10.0f, -12.5f)
                curveTo(22.0f, 5.42f, 19.58f, 3.0f, 16.5f, 3.0f)
                close()
            }
        }
        return _heartBroken!!
    }

private var _heartBroken: ImageVector? = null
