/*
 * Copyright 2022 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package androidx.compose.material.icons.filled

import androidx.compose.material.icons.Icons
import androidx.compose.material.icons.materialIcon
import androidx.compose.material.icons.materialPath
import androidx.compose.ui.graphics.vector.ImageVector

public val Icons.Filled.DesktopAccessDisabled: ImageVector
    get() {
        if (_desktopAccessDisabled != null) {
            return _desktopAccessDisabled!!
        }
        _desktopAccessDisabled = materialIcon(name = "Filled.DesktopAccessDisabled") {
            materialPath {
                moveTo(23.0f, 16.0f)
                curveToRelative(0.0f, 1.1f, -0.9f, 2.0f, -2.0f, 2.0f)
                horizontalLineToRelative(-1.0f)
                lineToRelative(-2.0f, -2.0f)
                horizontalLineToRelative(3.0f)
                lineTo(21.0f, 4.0f)
                lineTo(6.0f, 4.0f)
                lineTo(4.0f, 2.0f)
                horizontalLineToRelative(17.0f)
                curveToRelative(1.1f, 0.0f, 2.0f, 0.9f, 2.0f, 2.0f)
                verticalLineToRelative(12.0f)
                close()
                moveTo(17.5f, 18.0f)
                lineToRelative(-2.0f, -2.0f)
                close()
                moveTo(14.9f, 18.0f)
                lineToRelative(6.0f, 6.0f)
                lineToRelative(1.3f, -1.3f)
                lineToRelative(-4.7f, -4.7f)
                lineToRelative(-2.0f, -2.0f)
                lineTo(1.2f, 1.8f)
                lineTo(0.0f, 3.1f)
                lineToRelative(1.0f, 1.0f)
                lineTo(1.0f, 16.0f)
                curveToRelative(0.0f, 1.1f, 0.9f, 2.0f, 2.0f, 2.0f)
                horizontalLineToRelative(7.0f)
                verticalLineToRelative(2.0f)
                lineTo(8.0f, 20.0f)
                verticalLineToRelative(2.0f)
                horizontalLineToRelative(8.0f)
                verticalLineToRelative(-2.0f)
                horizontalLineToRelative(-2.0f)
                verticalLineToRelative(-2.0f)
                horizontalLineToRelative(0.9f)
                close()
                moveTo(3.0f, 16.0f)
                lineTo(3.0f, 6.1f)
                lineToRelative(9.9f, 9.9f)
                lineTo(3.0f, 16.0f)
                close()
            }
        }
        return _desktopAccessDisabled!!
    }

private var _desktopAccessDisabled: ImageVector? = null
