/*
 * Copyright 2022 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package androidx.compose.material.icons.filled

import androidx.compose.material.icons.Icons
import androidx.compose.material.icons.materialIcon
import androidx.compose.material.icons.materialPath
import androidx.compose.ui.graphics.vector.ImageVector

public val Icons.Filled.BedroomBaby: ImageVector
    get() {
        if (_bedroomBaby != null) {
            return _bedroomBaby!!
        }
        _bedroomBaby = materialIcon(name = "Filled.BedroomBaby") {
            materialPath {
                moveTo(20.0f, 2.0f)
                horizontalLineTo(4.0f)
                curveTo(2.9f, 2.0f, 2.0f, 2.9f, 2.0f, 4.0f)
                verticalLineToRelative(16.0f)
                curveToRelative(0.0f, 1.1f, 0.9f, 2.0f, 2.0f, 2.0f)
                horizontalLineToRelative(16.0f)
                curveToRelative(1.1f, 0.0f, 2.0f, -0.9f, 2.0f, -2.0f)
                verticalLineTo(4.0f)
                curveTo(22.0f, 2.9f, 21.1f, 2.0f, 20.0f, 2.0f)
                close()
                moveTo(12.0f, 18.0f)
                curveToRelative(-2.64f, 0.0f, -5.13f, -1.03f, -7.0f, -2.9f)
                lineToRelative(1.06f, -1.06f)
                curveToRelative(0.34f, 0.34f, 0.71f, 0.65f, 1.1f, 0.92f)
                lineTo(8.0f, 13.5f)
                verticalLineTo(9.51f)
                lineTo(6.45f, 10.5f)
                lineToRelative(-0.95f, -1.0f)
                lineTo(7.0f, 7.76f)
                lineTo(6.0f, 7.0f)
                horizontalLineToRelative(3.65f)
                lineToRelative(1.73f, 3.0f)
                horizontalLineTo(17.0f)
                verticalLineToRelative(1.0f)
                horizontalLineToRelative(-1.0f)
                verticalLineToRelative(2.5f)
                lineToRelative(0.84f, 1.46f)
                curveToRelative(0.39f, -0.28f, 0.76f, -0.58f, 1.1f, -0.92f)
                lineTo(19.0f, 15.1f)
                curveTo(17.13f, 16.97f, 14.64f, 18.0f, 12.0f, 18.0f)
                close()
            }
            materialPath {
                moveTo(14.69f, 14.24f)
                curveToRelative(-1.74f, 0.65f, -3.66f, 0.65f, -5.4f, 0.0f)
                lineToRelative(-0.81f, 1.41f)
                lineToRelative(-0.03f, 0.06f)
                curveToRelative(1.1f, 0.52f, 2.28f, 0.79f, 3.53f, 0.79f)
                reflectiveCurveToRelative(2.45f, -0.28f, 3.55f, -0.79f)
                lineToRelative(-0.03f, -0.06f)
                lineTo(14.69f, 14.24f)
                close()
            }
        }
        return _bedroomBaby!!
    }

private var _bedroomBaby: ImageVector? = null
