/*
 * Copyright 2022 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package androidx.compose.material.icons.twotone

import androidx.compose.material.icons.Icons
import androidx.compose.material.icons.materialIcon
import androidx.compose.material.icons.materialPath
import androidx.compose.ui.graphics.vector.ImageVector

public val Icons.TwoTone.ViewModule: ImageVector
    get() {
        if (_viewModule != null) {
            return _viewModule!!
        }
        _viewModule = materialIcon(name = "TwoTone.ViewModule") {
            materialPath(fillAlpha = 0.3f, strokeAlpha = 0.3f) {
                moveTo(19.0f, 11.0f)
                horizontalLineToRelative(-3.33f)
                verticalLineTo(7.0f)
                horizontalLineTo(19.0f)
                verticalLineTo(11.0f)
                close()
                moveTo(13.67f, 11.0f)
                horizontalLineToRelative(-3.33f)
                verticalLineTo(7.0f)
                horizontalLineToRelative(3.33f)
                verticalLineTo(11.0f)
                close()
                moveTo(8.33f, 7.0f)
                verticalLineToRelative(4.0f)
                horizontalLineTo(5.0f)
                verticalLineTo(7.0f)
                horizontalLineTo(8.33f)
                close()
                moveTo(5.0f, 17.0f)
                verticalLineToRelative(-4.0f)
                horizontalLineToRelative(3.33f)
                verticalLineToRelative(4.0f)
                horizontalLineTo(5.0f)
                close()
                moveTo(10.33f, 17.0f)
                verticalLineToRelative(-4.0f)
                horizontalLineToRelative(3.33f)
                verticalLineToRelative(4.0f)
                horizontalLineTo(10.33f)
                close()
                moveTo(15.67f, 17.0f)
                verticalLineToRelative(-4.0f)
                horizontalLineTo(19.0f)
                verticalLineToRelative(4.0f)
                horizontalLineTo(15.67f)
                close()
            }
            materialPath {
                moveTo(3.0f, 5.0f)
                verticalLineToRelative(14.0f)
                horizontalLineToRelative(18.0f)
                verticalLineTo(5.0f)
                horizontalLineTo(3.0f)
                close()
                moveTo(19.0f, 11.0f)
                horizontalLineToRelative(-3.33f)
                verticalLineTo(7.0f)
                horizontalLineTo(19.0f)
                verticalLineTo(11.0f)
                close()
                moveTo(13.67f, 11.0f)
                horizontalLineToRelative(-3.33f)
                verticalLineTo(7.0f)
                horizontalLineToRelative(3.33f)
                verticalLineTo(11.0f)
                close()
                moveTo(8.33f, 7.0f)
                verticalLineToRelative(4.0f)
                horizontalLineTo(5.0f)
                verticalLineTo(7.0f)
                horizontalLineTo(8.33f)
                close()
                moveTo(5.0f, 17.0f)
                verticalLineToRelative(-4.0f)
                horizontalLineToRelative(3.33f)
                verticalLineToRelative(4.0f)
                horizontalLineTo(5.0f)
                close()
                moveTo(10.33f, 17.0f)
                verticalLineToRelative(-4.0f)
                horizontalLineToRelative(3.33f)
                verticalLineToRelative(4.0f)
                horizontalLineTo(10.33f)
                close()
                moveTo(15.67f, 17.0f)
                verticalLineToRelative(-4.0f)
                horizontalLineTo(19.0f)
                verticalLineToRelative(4.0f)
                horizontalLineTo(15.67f)
                close()
            }
        }
        return _viewModule!!
    }

private var _viewModule: ImageVector? = null
