/*
 * Copyright 2022 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package androidx.compose.material.icons.twotone

import androidx.compose.material.icons.Icons
import androidx.compose.material.icons.materialIcon
import androidx.compose.material.icons.materialPath
import androidx.compose.ui.graphics.vector.ImageVector

public val Icons.TwoTone.Sick: ImageVector
    get() {
        if (_sick != null) {
            return _sick!!
        }
        _sick = materialIcon(name = "TwoTone.Sick") {
            materialPath {
                moveTo(7.32f, 10.56f)
                lineTo(8.38f, 9.5f)
                lineTo(7.32f, 8.44f)
                lineToRelative(1.06f, -1.06f)
                lineTo(10.5f, 9.5f)
                lineToRelative(-2.12f, 2.12f)
                lineTo(7.32f, 10.56f)
                close()
                moveTo(4.5f, 9.0f)
                curveToRelative(0.03f, 0.0f, 0.05f, 0.01f, 0.08f, 0.01f)
                curveTo(5.77f, 6.07f, 8.64f, 4.0f, 12.0f, 4.0f)
                curveToRelative(2.19f, 0.0f, 4.16f, 0.88f, 5.61f, 2.3f)
                curveToRelative(0.15f, -0.6f, 0.45f, -1.29f, 0.81f, -1.96f)
                curveTo(16.68f, 2.88f, 14.44f, 2.0f, 11.99f, 2.0f)
                curveToRelative(-4.88f, 0.0f, -8.94f, 3.51f, -9.81f, 8.14f)
                curveTo(2.74f, 9.44f, 3.59f, 9.0f, 4.5f, 9.0f)
                close()
                moveTo(21.0f, 10.5f)
                curveToRelative(-0.42f, 0.0f, -0.82f, -0.09f, -1.19f, -0.22f)
                curveTo(19.93f, 10.83f, 20.0f, 11.41f, 20.0f, 12.0f)
                curveToRelative(0.0f, 4.42f, -3.58f, 8.0f, -8.0f, 8.0f)
                curveToRelative(-3.36f, 0.0f, -6.23f, -2.07f, -7.42f, -5.01f)
                curveTo(4.55f, 14.99f, 4.53f, 15.0f, 4.5f, 15.0f)
                curveToRelative(-0.52f, 0.0f, -1.04f, -0.14f, -1.5f, -0.4f)
                curveToRelative(-0.32f, -0.18f, -0.59f, -0.42f, -0.82f, -0.7f)
                curveToRelative(0.89f, 4.61f, 4.93f, 8.1f, 9.8f, 8.1f)
                curveTo(17.52f, 22.0f, 22.0f, 17.52f, 22.0f, 12.0f)
                curveToRelative(0.0f, -0.55f, -0.06f, -1.09f, -0.14f, -1.62f)
                curveTo(21.58f, 10.45f, 21.3f, 10.5f, 21.0f, 10.5f)
                close()
                moveTo(21.0f, 3.0f)
                curveToRelative(0.0f, 0.0f, -2.0f, 2.9f, -2.0f, 4.0f)
                curveToRelative(0.0f, 1.1f, 0.9f, 2.0f, 2.0f, 2.0f)
                reflectiveCurveToRelative(2.0f, -0.9f, 2.0f, -2.0f)
                curveTo(23.0f, 5.9f, 21.0f, 3.0f, 21.0f, 3.0f)
                close()
                moveTo(15.62f, 7.38f)
                lineTo(13.5f, 9.5f)
                lineToRelative(2.12f, 2.12f)
                lineToRelative(1.06f, -1.06f)
                lineTo(15.62f, 9.5f)
                lineToRelative(1.06f, -1.06f)
                lineTo(15.62f, 7.38f)
                close()
                moveTo(8.56f, 17.0f)
                curveToRelative(0.69f, -1.19f, 1.97f, -2.0f, 3.44f, -2.0f)
                reflectiveCurveToRelative(2.75f, 0.81f, 3.44f, 2.0f)
                horizontalLineToRelative(1.68f)
                curveToRelative(-0.8f, -2.05f, -2.79f, -3.5f, -5.12f, -3.5f)
                curveToRelative(-0.87f, 0.0f, -1.7f, 0.2f, -2.43f, 0.57f)
                lineToRelative(0.0f, 0.0f)
                lineTo(5.99f, 12.0f)
                curveToRelative(0.0f, -0.52f, -0.26f, -1.02f, -0.74f, -1.29f)
                curveToRelative(-0.72f, -0.41f, -1.63f, -0.17f, -2.05f, 0.55f)
                curveToRelative(-0.41f, 0.72f, -0.17f, 1.63f, 0.55f, 2.05f)
                curveToRelative(0.48f, 0.28f, 1.05f, 0.25f, 1.49f, 0.0f)
                lineToRelative(2.97f, 1.72f)
                lineToRelative(0.0f, 0.0f)
                curveTo(7.64f, 15.56f, 7.18f, 16.24f, 6.88f, 17.0f)
                horizontalLineTo(8.56f)
                close()
            }
        }
        return _sick!!
    }

private var _sick: ImageVector? = null
