/*
 * Copyright 2022 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package androidx.compose.material.icons.twotone

import androidx.compose.material.icons.Icons
import androidx.compose.material.icons.materialIcon
import androidx.compose.material.icons.materialPath
import androidx.compose.ui.graphics.vector.ImageVector

public val Icons.TwoTone.SentimentVerySatisfied: ImageVector
    get() {
        if (_sentimentVerySatisfied != null) {
            return _sentimentVerySatisfied!!
        }
        _sentimentVerySatisfied = materialIcon(name = "TwoTone.SentimentVerySatisfied") {
            materialPath(fillAlpha = 0.3f, strokeAlpha = 0.3f) {
                moveTo(12.0f, 4.0f)
                curveToRelative(-4.42f, 0.0f, -8.0f, 3.58f, -8.0f, 8.0f)
                reflectiveCurveToRelative(3.58f, 8.0f, 8.0f, 8.0f)
                reflectiveCurveToRelative(8.0f, -3.58f, 8.0f, -8.0f)
                reflectiveCurveToRelative(-3.58f, -8.0f, -8.0f, -8.0f)
                close()
                moveTo(8.88f, 7.82f)
                lineTo(11.0f, 9.94f)
                lineTo(9.94f, 11.0f)
                lineTo(8.88f, 9.94f)
                lineTo(7.82f, 11.0f)
                lineTo(6.76f, 9.94f)
                lineToRelative(2.12f, -2.12f)
                close()
                moveTo(12.0f, 17.5f)
                curveToRelative(-2.33f, 0.0f, -4.31f, -1.46f, -5.11f, -3.5f)
                horizontalLineToRelative(10.22f)
                curveToRelative(-0.8f, 2.04f, -2.78f, 3.5f, -5.11f, 3.5f)
                close()
                moveTo(16.18f, 11.0f)
                lineToRelative(-1.06f, -1.06f)
                lineTo(14.06f, 11.0f)
                lineTo(13.0f, 9.94f)
                lineToRelative(2.12f, -2.12f)
                lineToRelative(2.12f, 2.12f)
                lineTo(16.18f, 11.0f)
                close()
            }
            materialPath {
                moveTo(8.88f, 9.94f)
                lineTo(9.94f, 11.0f)
                lineTo(11.0f, 9.94f)
                lineTo(8.88f, 7.82f)
                lineTo(6.76f, 9.94f)
                lineTo(7.82f, 11.0f)
                close()
                moveTo(13.0f, 9.94f)
                lineTo(14.06f, 11.0f)
                lineToRelative(1.06f, -1.06f)
                lineTo(16.18f, 11.0f)
                lineToRelative(1.06f, -1.06f)
                lineToRelative(-2.12f, -2.12f)
                close()
                moveTo(11.99f, 2.0f)
                curveTo(6.47f, 2.0f, 2.0f, 6.47f, 2.0f, 12.0f)
                reflectiveCurveToRelative(4.47f, 10.0f, 9.99f, 10.0f)
                reflectiveCurveTo(22.0f, 17.53f, 22.0f, 12.0f)
                reflectiveCurveTo(17.52f, 2.0f, 11.99f, 2.0f)
                close()
                moveTo(12.0f, 20.0f)
                curveToRelative(-4.42f, 0.0f, -8.0f, -3.58f, -8.0f, -8.0f)
                reflectiveCurveToRelative(3.58f, -8.0f, 8.0f, -8.0f)
                reflectiveCurveToRelative(8.0f, 3.58f, 8.0f, 8.0f)
                reflectiveCurveToRelative(-3.58f, 8.0f, -8.0f, 8.0f)
                close()
                moveTo(12.0f, 17.5f)
                curveToRelative(2.33f, 0.0f, 4.31f, -1.46f, 5.11f, -3.5f)
                lineTo(6.89f, 14.0f)
                curveToRelative(0.8f, 2.04f, 2.78f, 3.5f, 5.11f, 3.5f)
                close()
            }
        }
        return _sentimentVerySatisfied!!
    }

private var _sentimentVerySatisfied: ImageVector? = null
