/*
 * Copyright 2022 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package androidx.compose.material.icons.twotone

import androidx.compose.material.icons.Icons
import androidx.compose.material.icons.materialIcon
import androidx.compose.material.icons.materialPath
import androidx.compose.ui.graphics.vector.ImageVector

public val Icons.TwoTone.Mouse: ImageVector
    get() {
        if (_mouse != null) {
            return _mouse!!
        }
        _mouse = materialIcon(name = "TwoTone.Mouse") {
            materialPath(fillAlpha = 0.3f, strokeAlpha = 0.3f) {
                moveTo(13.0f, 3.16f)
                lineTo(13.0f, 9.0f)
                horizontalLineToRelative(5.0f)
                curveToRelative(-0.04f, -2.94f, -2.19f, -5.37f, -5.0f, -5.84f)
                close()
                moveTo(11.0f, 3.16f)
                curveTo(8.19f, 3.63f, 6.04f, 6.06f, 6.0f, 9.0f)
                horizontalLineToRelative(5.0f)
                lineTo(11.0f, 3.16f)
                close()
                moveTo(11.0f, 11.0f)
                lineTo(6.0f, 11.0f)
                verticalLineToRelative(4.0f)
                curveToRelative(0.0f, 3.31f, 2.69f, 6.0f, 6.0f, 6.0f)
                reflectiveCurveToRelative(6.0f, -2.69f, 6.0f, -6.0f)
                verticalLineToRelative(-4.0f)
                horizontalLineToRelative(-7.0f)
                close()
            }
            materialPath {
                moveTo(20.0f, 9.0f)
                curveToRelative(-0.04f, -4.39f, -3.6f, -7.93f, -8.0f, -7.93f)
                reflectiveCurveTo(4.04f, 4.61f, 4.0f, 9.0f)
                verticalLineToRelative(6.0f)
                curveToRelative(0.0f, 4.42f, 3.58f, 8.0f, 8.0f, 8.0f)
                reflectiveCurveToRelative(8.0f, -3.58f, 8.0f, -8.0f)
                lineTo(20.0f, 9.0f)
                close()
                moveTo(13.0f, 3.16f)
                curveToRelative(2.81f, 0.47f, 4.96f, 2.9f, 5.0f, 5.84f)
                horizontalLineToRelative(-5.0f)
                lineTo(13.0f, 3.16f)
                close()
                moveTo(11.0f, 3.16f)
                lineTo(11.0f, 9.0f)
                lineTo(6.0f, 9.0f)
                curveToRelative(0.04f, -2.94f, 2.19f, -5.37f, 5.0f, -5.84f)
                close()
                moveTo(18.0f, 15.0f)
                curveToRelative(0.0f, 3.31f, -2.69f, 6.0f, -6.0f, 6.0f)
                reflectiveCurveToRelative(-6.0f, -2.69f, -6.0f, -6.0f)
                verticalLineToRelative(-4.0f)
                horizontalLineToRelative(12.0f)
                verticalLineToRelative(4.0f)
                close()
            }
        }
        return _mouse!!
    }

private var _mouse: ImageVector? = null
