/*
 * Copyright 2022 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package androidx.compose.material.icons.twotone

import androidx.compose.material.icons.Icons
import androidx.compose.material.icons.materialIcon
import androidx.compose.material.icons.materialPath
import androidx.compose.ui.graphics.vector.ImageVector

public val Icons.TwoTone.ImageNotSupported: ImageVector
    get() {
        if (_imageNotSupported != null) {
            return _imageNotSupported!!
        }
        _imageNotSupported = materialIcon(name = "TwoTone.ImageNotSupported") {
            materialPath(fillAlpha = 0.3f, strokeAlpha = 0.3f) {
                moveTo(7.83f, 5.0f)
                horizontalLineTo(19.0f)
                verticalLineToRelative(11.17f)
                lineTo(7.83f, 5.0f)
                close()
                moveTo(16.17f, 19.0f)
                lineToRelative(-2.0f, -2.0f)
                horizontalLineTo(6.0f)
                lineToRelative(3.0f, -4.0f)
                lineToRelative(2.0f, 2.72f)
                lineToRelative(0.84f, -1.05f)
                lineTo(5.0f, 7.83f)
                verticalLineTo(19.0f)
                horizontalLineTo(16.17f)
                close()
            }
            materialPath {
                moveTo(5.83f, 3.0f)
                horizontalLineTo(19.0f)
                curveToRelative(1.1f, 0.0f, 2.0f, 0.9f, 2.0f, 2.0f)
                verticalLineToRelative(13.17f)
                lineToRelative(-2.0f, -2.0f)
                verticalLineTo(5.0f)
                horizontalLineTo(7.83f)
                lineTo(5.83f, 3.0f)
                close()
                moveTo(20.49f, 23.31f)
                lineTo(18.17f, 21.0f)
                horizontalLineTo(5.0f)
                curveToRelative(-1.1f, 0.0f, -2.0f, -0.9f, -2.0f, -2.0f)
                verticalLineTo(5.83f)
                lineTo(0.69f, 3.51f)
                lineTo(2.1f, 2.1f)
                lineToRelative(1.49f, 1.49f)
                lineTo(5.0f, 5.0f)
                lineToRelative(8.11f, 8.11f)
                lineToRelative(2.69f, 2.69f)
                lineTo(19.0f, 19.0f)
                lineToRelative(1.41f, 1.41f)
                lineToRelative(1.49f, 1.49f)
                lineTo(20.49f, 23.31f)
                close()
                moveTo(16.17f, 19.0f)
                lineToRelative(-2.0f, -2.0f)
                horizontalLineTo(6.0f)
                lineToRelative(3.0f, -4.0f)
                lineToRelative(2.0f, 2.72f)
                lineToRelative(0.84f, -1.05f)
                lineTo(5.0f, 7.83f)
                verticalLineTo(19.0f)
                horizontalLineTo(16.17f)
                close()
            }
        }
        return _imageNotSupported!!
    }

private var _imageNotSupported: ImageVector? = null
