/*
 * Copyright 2022 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package androidx.compose.material.icons.twotone

import androidx.compose.material.icons.Icons
import androidx.compose.material.icons.materialIcon
import androidx.compose.material.icons.materialPath
import androidx.compose.ui.graphics.vector.ImageVector

public val Icons.TwoTone.ConnectingAirports: ImageVector
    get() {
        if (_connectingAirports != null) {
            return _connectingAirports!!
        }
        _connectingAirports = materialIcon(name = "TwoTone.ConnectingAirports") {
            materialPath {
                moveTo(15.4f, 17.0f)
                lineToRelative(1.3f, 4.4f)
                horizontalLineToRelative(-1.1f)
                lineTo(13.0f, 17.0f)
                horizontalLineToRelative(-3.0f)
                curveToRelative(-0.55f, 0.0f, -1.0f, -0.45f, -1.0f, -1.0f)
                curveToRelative(0.0f, -0.55f, 0.45f, -1.0f, 1.0f, -1.0f)
                horizontalLineToRelative(3.0f)
                lineToRelative(2.6f, -4.4f)
                horizontalLineToRelative(1.1f)
                lineTo(15.4f, 15.0f)
                horizontalLineToRelative(2.85f)
                lineTo(19.0f, 14.0f)
                horizontalLineToRelative(1.0f)
                lineToRelative(-0.6f, 2.0f)
                lineToRelative(0.6f, 2.0f)
                horizontalLineToRelative(-1.0f)
                lineToRelative(-0.75f, -1.0f)
                horizontalLineTo(15.4f)
                close()
                moveTo(5.75f, 7.0f)
                lineTo(5.0f, 6.0f)
                horizontalLineTo(4.0f)
                lineToRelative(0.6f, 2.0f)
                lineTo(4.0f, 10.0f)
                horizontalLineToRelative(1.0f)
                lineToRelative(0.75f, -1.0f)
                horizontalLineTo(8.6f)
                lineToRelative(-1.3f, 4.4f)
                horizontalLineToRelative(1.1f)
                lineTo(11.0f, 9.0f)
                horizontalLineToRelative(3.0f)
                curveToRelative(0.55f, 0.0f, 1.0f, -0.45f, 1.0f, -1.0f)
                reflectiveCurveToRelative(-0.45f, -1.0f, -1.0f, -1.0f)
                horizontalLineToRelative(-3.0f)
                lineTo(8.4f, 2.6f)
                horizontalLineTo(7.3f)
                lineTo(8.6f, 7.0f)
                horizontalLineTo(5.75f)
                close()
            }
        }
        return _connectingAirports!!
    }

private var _connectingAirports: ImageVector? = null
