/*
 * Copyright 2022 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package androidx.compose.material.icons.twotone

import androidx.compose.material.icons.Icons
import androidx.compose.material.icons.materialIcon
import androidx.compose.material.icons.materialPath
import androidx.compose.ui.graphics.vector.ImageVector

public val Icons.TwoTone.BrowserNotSupported: ImageVector
    get() {
        if (_browserNotSupported != null) {
            return _browserNotSupported!!
        }
        _browserNotSupported = materialIcon(name = "TwoTone.BrowserNotSupported") {
            materialPath {
                moveTo(19.0f, 6.0f)
                verticalLineToRelative(10.5f)
                lineToRelative(1.95f, 1.95f)
                curveTo(20.98f, 18.3f, 21.0f, 18.15f, 21.0f, 18.0f)
                verticalLineTo(6.0f)
                curveToRelative(0.0f, -1.1f, -0.9f, -2.0f, -2.0f, -2.0f)
                horizontalLineTo(6.5f)
                lineToRelative(2.0f, 2.0f)
                horizontalLineTo(19.0f)
                close()
            }
            materialPath {
                moveTo(3.22f, 3.32f)
                lineTo(1.95f, 4.59f)
                lineTo(3.0f, 5.64f)
                lineTo(3.0f, 18.0f)
                curveToRelative(0.0f, 1.1f, 0.9f, 2.0f, 2.0f, 2.0f)
                horizontalLineToRelative(12.36f)
                lineToRelative(2.06f, 2.06f)
                lineToRelative(1.27f, -1.27f)
                lineTo(3.22f, 3.32f)
                close()
                moveTo(15.0f, 18.0f)
                horizontalLineTo(5.0f)
                verticalLineTo(7.64f)
                lineTo(15.36f, 18.0f)
                horizontalLineTo(15.0f)
                close()
            }
        }
        return _browserNotSupported!!
    }

private var _browserNotSupported: ImageVector? = null
