/*
 * Copyright 2022 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package androidx.compose.material.icons.twotone

import androidx.compose.material.icons.Icons
import androidx.compose.material.icons.materialIcon
import androidx.compose.material.icons.materialPath
import androidx.compose.ui.graphics.vector.ImageVector

public val Icons.TwoTone.AdminPanelSettings: ImageVector
    get() {
        if (_adminPanelSettings != null) {
            return _adminPanelSettings!!
        }
        _adminPanelSettings = materialIcon(name = "TwoTone.AdminPanelSettings") {
            materialPath(fillAlpha = 0.3f, strokeAlpha = 0.3f) {
                moveTo(16.0f, 7.58f)
                lineToRelative(-5.5f, -2.4f)
                lineTo(5.0f, 7.58f)
                verticalLineToRelative(3.6f)
                curveToRelative(0.0f, 3.5f, 2.33f, 6.74f, 5.5f, 7.74f)
                curveToRelative(0.25f, -0.08f, 0.49f, -0.2f, 0.73f, -0.3f)
                curveTo(11.08f, 18.11f, 11.0f, 17.56f, 11.0f, 17.0f)
                curveToRelative(0.0f, -2.97f, 2.16f, -5.43f, 5.0f, -5.91f)
                verticalLineTo(7.58f)
                close()
            }
            materialPath(fillAlpha = 0.3f, strokeAlpha = 0.3f) {
                moveTo(17.0f, 13.0f)
                curveToRelative(-2.21f, 0.0f, -4.0f, 1.79f, -4.0f, 4.0f)
                curveToRelative(0.0f, 2.21f, 1.79f, 4.0f, 4.0f, 4.0f)
                reflectiveCurveToRelative(4.0f, -1.79f, 4.0f, -4.0f)
                curveTo(21.0f, 14.79f, 19.21f, 13.0f, 17.0f, 13.0f)
                close()
                moveTo(17.0f, 14.38f)
                curveToRelative(0.62f, 0.0f, 1.12f, 0.51f, 1.12f, 1.12f)
                reflectiveCurveToRelative(-0.51f, 1.12f, -1.12f, 1.12f)
                reflectiveCurveToRelative(-1.12f, -0.51f, -1.12f, -1.12f)
                reflectiveCurveTo(16.38f, 14.38f, 17.0f, 14.38f)
                close()
                moveTo(17.0f, 19.75f)
                curveToRelative(-0.93f, 0.0f, -1.74f, -0.46f, -2.24f, -1.17f)
                curveToRelative(0.05f, -0.72f, 1.51f, -1.08f, 2.24f, -1.08f)
                reflectiveCurveToRelative(2.19f, 0.36f, 2.24f, 1.08f)
                curveTo(18.74f, 19.29f, 17.93f, 19.75f, 17.0f, 19.75f)
                close()
            }
            materialPath {
                moveTo(17.0f, 15.5f)
                moveToRelative(-1.12f, 0.0f)
                arcToRelative(1.12f, 1.12f, 0.0f, true, true, 2.24f, 0.0f)
                arcToRelative(1.12f, 1.12f, 0.0f, true, true, -2.24f, 0.0f)
            }
            materialPath {
                moveTo(18.0f, 11.09f)
                verticalLineTo(6.27f)
                lineTo(10.5f, 3.0f)
                lineTo(3.0f, 6.27f)
                verticalLineToRelative(4.91f)
                curveToRelative(0.0f, 4.54f, 3.2f, 8.79f, 7.5f, 9.82f)
                curveToRelative(0.55f, -0.13f, 1.08f, -0.32f, 1.6f, -0.55f)
                curveTo(13.18f, 21.99f, 14.97f, 23.0f, 17.0f, 23.0f)
                curveToRelative(3.31f, 0.0f, 6.0f, -2.69f, 6.0f, -6.0f)
                curveTo(23.0f, 14.03f, 20.84f, 11.57f, 18.0f, 11.09f)
                close()
                moveTo(11.0f, 17.0f)
                curveToRelative(0.0f, 0.56f, 0.08f, 1.11f, 0.23f, 1.62f)
                curveToRelative(-0.24f, 0.11f, -0.48f, 0.22f, -0.73f, 0.3f)
                curveToRelative(-3.17f, -1.0f, -5.5f, -4.24f, -5.5f, -7.74f)
                verticalLineToRelative(-3.6f)
                lineToRelative(5.5f, -2.4f)
                lineToRelative(5.5f, 2.4f)
                verticalLineToRelative(3.51f)
                curveTo(13.16f, 11.57f, 11.0f, 14.03f, 11.0f, 17.0f)
                close()
                moveTo(17.0f, 21.0f)
                curveToRelative(-2.21f, 0.0f, -4.0f, -1.79f, -4.0f, -4.0f)
                curveToRelative(0.0f, -2.21f, 1.79f, -4.0f, 4.0f, -4.0f)
                reflectiveCurveToRelative(4.0f, 1.79f, 4.0f, 4.0f)
                curveTo(21.0f, 19.21f, 19.21f, 21.0f, 17.0f, 21.0f)
                close()
            }
            materialPath {
                moveTo(17.0f, 17.5f)
                curveToRelative(-0.73f, 0.0f, -2.19f, 0.36f, -2.24f, 1.08f)
                curveToRelative(0.5f, 0.71f, 1.32f, 1.17f, 2.24f, 1.17f)
                reflectiveCurveToRelative(1.74f, -0.46f, 2.24f, -1.17f)
                curveTo(19.19f, 17.86f, 17.73f, 17.5f, 17.0f, 17.5f)
                close()
            }
        }
        return _adminPanelSettings!!
    }

private var _adminPanelSettings: ImageVector? = null
