/*
 * Copyright 2022 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package androidx.compose.material.icons.sharp

import androidx.compose.material.icons.Icons
import androidx.compose.material.icons.materialIcon
import androidx.compose.material.icons.materialPath
import androidx.compose.ui.graphics.vector.ImageVector

public val Icons.Sharp.Style: ImageVector
    get() {
        if (_style != null) {
            return _style!!
        }
        _style = materialIcon(name = "Sharp.Style") {
            materialPath {
                moveTo(3.87f, 20.21f)
                verticalLineToRelative(-9.03f)
                lineToRelative(-3.19f, 7.7f)
                lineToRelative(3.19f, 1.33f)
                close()
                moveTo(22.79f, 17.78f)
                lineTo(16.31f, 2.14f)
                lineTo(5.26f, 6.71f)
                lineToRelative(6.48f, 15.64f)
                lineToRelative(11.05f, -4.57f)
                close()
                moveTo(7.88f, 8.75f)
                curveToRelative(-0.55f, 0.0f, -1.0f, -0.45f, -1.0f, -1.0f)
                reflectiveCurveToRelative(0.45f, -1.0f, 1.0f, -1.0f)
                reflectiveCurveToRelative(1.0f, 0.45f, 1.0f, 1.0f)
                reflectiveCurveToRelative(-0.45f, 1.0f, -1.0f, 1.0f)
                close()
                moveTo(5.88f, 21.75f)
                horizontalLineToRelative(3.45f)
                lineToRelative(-3.45f, -8.34f)
                verticalLineToRelative(8.34f)
                close()
            }
        }
        return _style!!
    }

private var _style: ImageVector? = null
