/*
 * Copyright 2022 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package androidx.compose.material.icons.sharp

import androidx.compose.material.icons.Icons
import androidx.compose.material.icons.materialIcon
import androidx.compose.material.icons.materialPath
import androidx.compose.ui.graphics.vector.ImageVector

public val Icons.Sharp.SettingsApplications: ImageVector
    get() {
        if (_settingsApplications != null) {
            return _settingsApplications!!
        }
        _settingsApplications = materialIcon(name = "Sharp.SettingsApplications") {
            materialPath {
                moveTo(19.0f, 3.0f)
                lineTo(5.0f, 3.0f)
                curveToRelative(-1.11f, 0.0f, -2.0f, 0.9f, -2.0f, 2.0f)
                verticalLineToRelative(14.0f)
                curveToRelative(0.0f, 1.1f, 0.89f, 2.0f, 2.0f, 2.0f)
                horizontalLineToRelative(14.0f)
                curveToRelative(1.11f, 0.0f, 2.0f, -0.9f, 2.0f, -2.0f)
                lineTo(21.0f, 5.0f)
                curveToRelative(0.0f, -1.1f, -0.89f, -2.0f, -2.0f, -2.0f)
                close()
                moveTo(17.25f, 12.0f)
                curveToRelative(0.0f, 0.24f, -0.02f, 0.47f, -0.05f, 0.71f)
                lineToRelative(0.01f, -0.02f)
                lineToRelative(1.47f, 1.16f)
                curveToRelative(0.14f, 0.1f, 0.23f, 0.18f, 0.23f, 0.18f)
                lineToRelative(-1.7f, 2.94f)
                lineToRelative(-2.02f, -0.8f)
                lineToRelative(0.02f, -0.03f)
                curveToRelative(-0.37f, 0.29f, -0.77f, 0.53f, -1.21f, 0.71f)
                horizontalLineToRelative(0.01f)
                lineToRelative(-0.27f, 1.85f)
                curveToRelative(-0.02f, 0.17f, -0.04f, 0.3f, -0.04f, 0.3f)
                horizontalLineToRelative(-3.4f)
                lineToRelative(-0.31f, -2.15f)
                lineTo(10.0f, 16.85f)
                curveToRelative(-0.44f, -0.18f, -0.84f, -0.42f, -1.21f, -0.71f)
                lineToRelative(0.02f, 0.03f)
                lineToRelative(-2.02f, 0.8f)
                lineToRelative(-1.7f, -2.94f)
                reflectiveCurveToRelative(0.1f, -0.08f, 0.23f, -0.18f)
                lineToRelative(1.47f, -1.16f)
                lineToRelative(0.01f, 0.02f)
                curveToRelative(-0.03f, -0.24f, -0.05f, -0.47f, -0.05f, -0.71f)
                reflectiveCurveToRelative(0.02f, -0.47f, 0.05f, -0.69f)
                lineToRelative(-0.01f, 0.01f)
                lineToRelative(-1.7f, -1.34f)
                lineToRelative(1.7f, -2.95f)
                lineToRelative(2.01f, 0.81f)
                verticalLineToRelative(0.01f)
                curveToRelative(0.37f, -0.28f, 0.77f, -0.52f, 1.2f, -0.7f)
                horizontalLineToRelative(-0.01f)
                lineTo(10.3f, 5.0f)
                horizontalLineToRelative(3.41f)
                lineToRelative(0.3f, 2.15f)
                lineTo(14.0f, 7.15f)
                curveToRelative(0.43f, 0.18f, 0.83f, 0.42f, 1.2f, 0.7f)
                verticalLineToRelative(-0.01f)
                lineToRelative(2.01f, -0.81f)
                lineToRelative(1.7f, 2.95f)
                lineToRelative(-1.71f, 1.34f)
                lineToRelative(-0.01f, -0.01f)
                curveToRelative(0.04f, 0.22f, 0.06f, 0.45f, 0.06f, 0.69f)
                close()
            }
            materialPath {
                moveTo(12.0f, 12.0f)
                moveToRelative(-2.45f, 0.0f)
                arcToRelative(2.45f, 2.45f, 0.0f, true, true, 4.9f, 0.0f)
                arcToRelative(2.45f, 2.45f, 0.0f, true, true, -4.9f, 0.0f)
            }
        }
        return _settingsApplications!!
    }

private var _settingsApplications: ImageVector? = null
