/*
 * Copyright 2022 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package androidx.compose.material.icons.sharp

import androidx.compose.material.icons.Icons
import androidx.compose.material.icons.materialIcon
import androidx.compose.material.icons.materialPath
import androidx.compose.ui.graphics.vector.ImageVector

public val Icons.Sharp.RestaurantMenu: ImageVector
    get() {
        if (_restaurantMenu != null) {
            return _restaurantMenu!!
        }
        _restaurantMenu = materialIcon(name = "Sharp.RestaurantMenu") {
            materialPath {
                moveTo(8.1f, 13.34f)
                lineToRelative(2.83f, -2.83f)
                lineTo(3.91f, 3.5f)
                curveToRelative(-1.56f, 1.56f, -1.56f, 4.09f, 0.0f, 5.66f)
                lineToRelative(4.19f, 4.18f)
                close()
                moveTo(14.88f, 11.53f)
                curveToRelative(1.53f, 0.71f, 3.68f, 0.21f, 5.27f, -1.38f)
                curveToRelative(1.91f, -1.91f, 2.28f, -4.65f, 0.81f, -6.12f)
                curveToRelative(-1.46f, -1.46f, -4.2f, -1.1f, -6.12f, 0.81f)
                curveToRelative(-1.59f, 1.59f, -2.09f, 3.74f, -1.38f, 5.27f)
                lineTo(3.7f, 19.87f)
                lineToRelative(1.41f, 1.41f)
                lineTo(12.0f, 14.41f)
                lineToRelative(6.88f, 6.88f)
                lineToRelative(1.41f, -1.41f)
                lineTo(13.41f, 13.0f)
                lineToRelative(1.47f, -1.47f)
                close()
            }
        }
        return _restaurantMenu!!
    }

private var _restaurantMenu: ImageVector? = null
